/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.swing;

import com.openit.lego.logging.Logger;
import com.openit.lego.swing.SwingConstants;
import com.openit.lego.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ThresholdPanel
extends JPanel {
    private static final String[] THRESHOLD_OPTIONS = new String[]{"X > ", "X >=", "X =", "X <=", "X < ", "X <>"};
    private static final String THRESHOLD_DEFAULT = THRESHOLD_OPTIONS[0];
    private static final int TEXTFIELD_SIZE = 10;
    JComboBox comboBox = new JComboBox<String>(THRESHOLD_OPTIONS);
    JTextField textfield;

    public ThresholdPanel() {
        super(new BorderLayout());
        this.comboBox.setSelectedItem(THRESHOLD_DEFAULT);
        SwingUtils.setRaisedBevelBorder(this.comboBox);
        this.add((Component)this.comboBox, "West");
        this.textfield = new JTextField(10);
        this.textfield.setFont(SwingConstants.FNT_STRING);
        this.add((Component)this.textfield, "Center");
    }

    public String getSelection() {
        return (String)this.comboBox.getSelectedItem();
    }

    public String getValue() {
        return this.textfield.getText();
    }

    public String getDoubleValueAsString() {
        String value = this.getValue();
        if (value.equals("")) {
            return value;
        }
        try {
            Float numbervalue = Float.valueOf(value);
            return numbervalue.toString();
        }
        catch (NumberFormatException nfe) {
            Logger.warning("Threshold value '" + value + "' is not a valid float.");
            return "";
        }
    }

    public String getThresholdQuantifier() {
        String quantifier = this.getSelection();
        return quantifier.substring(2);
    }

    public String toString() {
        return this.getDoubleValueAsString() + ":" + this.getThresholdQuantifier();
    }
}

