/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.logging;

import com.openit.lego.logging.LoggerEvent;
import com.openit.lego.logging.LoggerListener;
import java.util.Date;
import javax.swing.event.EventListenerList;

public class Logger {
    public static final int CRITICAL = 1;
    public static final int ERROR = 2;
    public static final int WARNING = 3;
    public static final int INFO = 4;
    public static final int VERBOSE = 5;
    public static final int DEBUG = 6;
    public static final int TRACE = 7;
    private static final String[] levelsAsStrings = new String[]{"", "CRITICAL", "ERROR", "WARNING", "Info", "verbose", "debug", "trace"};
    private static final int DEFAULT_LEVEL = 4;
    private static final int HIGHEST_LEVEL = 7;
    private static int logLevel = 4;
    private static final String OPENIT_PREFIX = "[Open iT] ";
    private static EventListenerList[] listenerLists = new EventListenerList[8];

    public static void initialize() {
        for (int i = 1; i <= 7; ++i) {
            if (listenerLists[i] != null) continue;
            Logger.listenerLists[i] = new EventListenerList();
        }
    }

    public static void setLevel(int newLevel) {
        if (newLevel < 0 || newLevel > 7) {
            newLevel = 4;
        }
        logLevel = newLevel;
        Logger.printMessage("Log level set to '" + levelsAsStrings[newLevel] + "'");
    }

    public static void setLevel(String newLevel) {
        int newLevelAsChar;
        if (newLevel == null || newLevel.equals("")) {
            newLevelAsChar = 32;
        } else {
            newLevel = newLevel.toLowerCase();
            try {
                newLevelAsChar = newLevel.charAt(0);
            }
            catch (IndexOutOfBoundsException ioobe) {
                newLevelAsChar = 32;
            }
        }
        switch (newLevelAsChar) {
            case 99: {
                Logger.setLevel(1);
                break;
            }
            case 101: {
                Logger.setLevel(2);
                break;
            }
            case 119: {
                Logger.setLevel(3);
                break;
            }
            case 105: {
                Logger.setLevel(4);
                break;
            }
            case 118: {
                Logger.setLevel(5);
                break;
            }
            case 100: {
                Logger.setLevel(6);
                break;
            }
            case 116: {
                Logger.setLevel(7);
                break;
            }
            case 32: {
                Logger.setLevel(4);
                break;
            }
            default: {
                Logger.warning("Unrecognized loglevel '" + newLevel + "'. Setting loglevel to default");
                Logger.setLevel(4);
            }
        }
    }

    public static int getLevel() {
        return logLevel;
    }

    private static void printMessage(String message) {
        Date now = new Date();
        System.err.println(OPENIT_PREFIX + now + " " + message);
    }

    public static void critical(String message) {
        if (Logger.getLevel() >= 1) {
            String prefix = "[CRITICAL] ";
            Logger.fireLoggerEvent(new LoggerEvent(1, message, prefix));
        }
    }

    public static void error(String message) {
        if (Logger.getLevel() >= 2) {
            String prefix = "[ERROR]    ";
            Logger.fireLoggerEvent(new LoggerEvent(2, message, prefix));
        }
    }

    public static void warning(String message) {
        if (Logger.getLevel() >= 3) {
            String prefix = "[WARNING]  ";
            Logger.fireLoggerEvent(new LoggerEvent(3, message, prefix));
        }
    }

    public static void info(String message) {
        if (Logger.getLevel() >= 4) {
            String prefix = "[Info]     ";
            Logger.fireLoggerEvent(new LoggerEvent(4, message, prefix));
        }
    }

    public static void verbose(String message) {
        if (Logger.getLevel() >= 5) {
            String prefix = "[verbose]  ";
            Logger.fireLoggerEvent(new LoggerEvent(5, message, prefix));
        }
    }

    public static void debug(String message) {
        if (Logger.getLevel() >= 6) {
            String prefix = "[debug]    ";
            Logger.fireLoggerEvent(new LoggerEvent(6, message, prefix));
        }
    }

    public static void trace(String message) {
        if (Logger.getLevel() >= 7) {
            String prefix = "[trace]    ";
            Logger.fireLoggerEvent(new LoggerEvent(7, message, prefix));
        }
    }

    public static void addLoggerListener(LoggerListener listener, int level) {
        for (int i = 1; i <= level; ++i) {
            listenerLists[i].add(1.class$com$openit$lego$logging$LoggerListener == null ? 1.class$("com.openit.lego.logging.LoggerListener") : 1.class$com$openit$lego$logging$LoggerListener, listener);
            Logger.debug("Added listener for level '" + levelsAsStrings[i] + "' of class '" + listener.getClass().getName() + "'");
        }
    }

    public static void removeLoggerListener(LoggerListener listener) {
        Logger.debug("Removing listener of class '" + listener.getClass().getName() + "' from all LoggerListenerLists.");
        for (int i = 1; i <= 7; ++i) {
            listenerLists[i].remove(1.class$com$openit$lego$logging$LoggerListener == null ? 1.class$("com.openit.lego.logging.LoggerListener") : 1.class$com$openit$lego$logging$LoggerListener, listener);
        }
    }

    private static void fireLoggerEvent(LoggerEvent event) {
        Logger.printMessage(event.toString());
        EventListenerList listenerList = listenerLists[event.getLevel()];
        Object[] listeners = listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (1.class$com$openit$lego$logging$LoggerListener == null ? 1.class$("com.openit.lego.logging.LoggerListener") : 1.class$com$openit$lego$logging$LoggerListener)) continue;
            ((LoggerListener)listeners[i + 1]).messageLogged(event);
        }
    }

    static class 1 {
        static /* synthetic */ Class class$com$openit$lego$logging$LoggerListener;
        static /* synthetic */ ClassLoader cl$;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0, false, cl$ == null ? (cl$ = new 1[0].getClass().getComponentType().getClassLoader()) : cl$);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError().initCause(x1);
            }
        }
    }
}

