/*
 * Decompiled with CFR 0.152.
 */
package com.sitraka.licensing.util;

import com.sitraka.licensing.util.AssertionException;
import java.io.PrintStream;

public class Debug {
    protected static boolean enabled = false;
    protected static String[] tags = null;
    protected static int level = Integer.MAX_VALUE;
    protected static PrintStream stream = System.out;

    public static void setEnabled(boolean e) {
        enabled = e;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setPrintStream(PrintStream pstream) {
        stream = pstream;
    }

    public static PrintStream getPrintStream() {
        return stream;
    }

    public static void setLevel(int new_level) {
        level = new_level;
    }

    public static int getLevel() {
        return level;
    }

    public static void setTags(String[] new_tags) {
        tags = new_tags;
    }

    public static void setTag(String tag) {
        if (tag == null) {
            Debug.setTags(null);
        } else {
            String[] new_tags = new String[]{tag};
            Debug.setTags(new_tags);
        }
    }

    public static String[] getTags() {
        return tags;
    }

    public static final void assertThat(boolean condition) {
        if (enabled && !condition) {
            throw new AssertionException();
        }
    }

    public static final void assertThat(boolean condition, String message) {
        if (enabled && !condition) {
            throw new AssertionException(message);
        }
    }

    public static void printStackTrace() {
        try {
            throw new NullPointerException("Forced Stack Trace");
        }
        catch (NullPointerException e) {
            e.printStackTrace(stream);
            return;
        }
    }

    public static void printStackTrace(String s) {
        try {
            throw new NullPointerException(s);
        }
        catch (NullPointerException e) {
            e.printStackTrace(stream);
            return;
        }
    }

    public static void printStackTrace(String ptag, Throwable t) {
        if (!Debug.isPrintableTag(ptag)) {
            return;
        }
        t.printStackTrace(stream);
    }

    public static void print(int plevel, String ptag, String text) {
        if (!Debug.isPrintableLevel(plevel)) {
            return;
        }
        if (!Debug.isPrintableTag(ptag)) {
            return;
        }
        stream.print(text);
    }

    public static void print(int plevel, String text) {
        Debug.print(plevel, null, text);
    }

    public static void print(String ptag, String text) {
        Debug.print(0, ptag, text);
    }

    public static void print(String text) {
        Debug.print(0, null, text);
    }

    public static void println(int plevel, String ptag, String text) {
        if (!Debug.isPrintableLevel(plevel)) {
            return;
        }
        if (!Debug.isPrintableTag(ptag)) {
            return;
        }
        stream.println(text);
    }

    public static void println(int plevel, String text) {
        Debug.println(plevel, null, text);
    }

    public static void println(String ptag, String text) {
        Debug.println(0, ptag, text);
    }

    public static void println(String text) {
        Debug.println(0, null, text);
    }

    protected static boolean isPrintableLevel(int plevel) {
        if (!enabled) {
            return false;
        }
        return plevel <= level;
    }

    public static boolean isPrintableTag(String tag) {
        if (!enabled) {
            return false;
        }
        if (tag == null) {
            return true;
        }
        if (tags == null) {
            return false;
        }
        int i = 0;
        while (i < tags.length) {
            if (tag != null && tag.equals(tags[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

