/*
 * Decompiled with CFR 0.152.
 */
package com.openit.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCAxisFormula;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.PlotArea;
import com.klg.jclass.util.legend.JCLegend;
import com.openit.chart.OpenitChart;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.BorderUIResource;

public class ChartStyleLoader {
    private JCChart chart;

    public ChartStyleLoader(JCChart chart) {
        this.chart = chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createChartStyleFile() {
        JFileChooser fc = new JFileChooser();
        int command = fc.showSaveDialog(null);
        int overwrite = 0;
        if (fc.getSelectedFile() != null && fc.getSelectedFile().exists()) {
            overwrite = JOptionPane.showConfirmDialog(null, "Overwrite exisiting file?", "Save Chart's Style", 2);
        }
        if (command == 0 && overwrite == 0) {
            PrintStream ps = null;
            try {
                ps = new PrintStream(new FileOutputStream(fc.getSelectedFile()));
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger((1.class$com$openit$chart$OpenitChart == null ? (1.class$com$openit$chart$OpenitChart = 1.class$("com.openit.chart.OpenitChart")) : 1.class$com$openit$chart$OpenitChart).getName()).log(Level.SEVERE, null, ex);
            }
            this.printChartStyle(ps);
            this.printTriggers(ps);
            this.printJLabel((JLabel)this.chart.getHeader(), "header", ps);
            this.printJLabel((JLabel)this.chart.getFooter(), "footer", ps);
            this.printJComponent(this.chart.getHeader(), "header", ps);
            this.printJComponent(this.chart.getFooter(), "footer", ps);
            this.printJComponent((JComponent)this.chart.getLegend(), "legend", ps);
            this.printLegend(this.chart.getLegend(), ps);
            this.printJComponent((JComponent)this.chart.getChartArea(), "chartArea", ps);
            Color bg = this.chart.getChartArea().getPlotArea().getBackground();
            ps.println(this.getNameValueFormat("chartArea.plotArea.background", "" + bg.getRed() + "-" + bg.getGreen() + "-" + bg.getBlue()));
            List list = this.chart.getChartArea().getXAxes();
            this.printAxesStyle(list, "xaxis", ps);
            list = this.chart.getChartArea().getYAxes();
            this.printAxesStyle(list, "yaxis", ps);
            List data = this.chart.getDataView();
            for (int i = 0; i < data.size(); ++i) {
                ChartDataView dataView = (ChartDataView)data.get(i);
                List series = dataView.getSeries();
                ps.println(this.getNameValueFormat("data" + i + ".inverted", String.valueOf(dataView.isInverted())));
                String type = "Area";
                switch (dataView.getChartType()) {
                    case 12: {
                        type = "STACKING_AREA";
                        break;
                    }
                    case 9: {
                        type = "BAR";
                        break;
                    }
                    case 10: {
                        type = "STACKING_BAR";
                        break;
                    }
                    case 0: {
                        type = "PLOT";
                        break;
                    }
                    case 1: {
                        type = "SCATTER_PLOT";
                        break;
                    }
                    case 11: {
                        type = "PIE";
                    }
                }
                ps.println(this.getNameValueFormat("data" + i + ".chartType", type));
                ps.println(this.getNameValueFormat("data" + i + ".holeValue", String.valueOf(dataView.getHoleValue())));
                for (int j = 0; j < series.size(); ++j) {
                    this.printDataSeriesStyle((ChartDataViewSeries)series.get(j), ps, j, i);
                }
            }
            ps.close();
        } else if (command == 1 || command == -1) {
            // empty if block
        }
    }

    private void printDataSeriesStyle(ChartDataViewSeries series, PrintStream ps, int seriesIndex, int dataIndex) {
        JCChartStyle style = series.getStyle();
        String val = "Dot";
        switch (style.getSymbolShape()) {
            case 2: {
                val = "Box";
                break;
            }
            case 9: {
                val = "Circle";
                break;
            }
            case 8: {
                val = "Cross";
                break;
            }
            case 4: {
                val = "Diamond";
                break;
            }
            case 0: {
                val = "None";
                break;
            }
            case 10: {
                val = "Square";
                break;
            }
            case 3: {
                val = "Triangle";
                break;
            }
            case 5: {
                val = "Star";
                break;
            }
            case 6: {
                val = "Vert_Line";
                break;
            }
            case 7: {
                val = "Horiz_Line";
            }
        }
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".symbol.shape", val));
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".symbol.color", this.getRGBString(style.getSymbolColor())));
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".symbol.size", String.valueOf(style.getSymbolSize())));
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".line.color", this.getRGBString(style.getLineColor())));
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".line.width", String.valueOf(style.getLineWidth())));
        val = "Miter";
        switch (style.getLineJoin()) {
            case 2: {
                val = "Bevel";
                break;
            }
            case 1: {
                val = "Round";
            }
        }
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".line.join", val));
        val = "Butt";
        switch (style.getLineCap()) {
            case 1: {
                val = "Round";
                break;
            }
            case 2: {
                val = "Square";
            }
        }
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".line.cap", val));
        val = "None";
        switch (style.getLinePattern()) {
            case 5: {
                val = "Dash_Dot";
                break;
            }
            case 2: {
                val = "Long_Dash";
                break;
            }
            case 4: {
                val = "LSL_Dash";
                break;
            }
            case 3: {
                val = "Short_Dash";
                break;
            }
            case 1: {
                val = "Solid";
            }
        }
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".line.pattern", val));
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".fill.color", this.getRGBString(style.getFillColor())));
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".fill.background", this.getRGBString(style.getFillBackground())));
        val = "None";
        switch (style.getFillPattern()) {
            case 1: {
                val = "Solid";
                break;
            }
            case 2: {
                val = "Per_25";
                break;
            }
            case 3: {
                val = "Per_50";
                break;
            }
            case 4: {
                val = "Per_75";
                break;
            }
            case 5: {
                val = "Horiz_Stripe";
                break;
            }
            case 6: {
                val = "Vert_Stripe";
                break;
            }
            case 7: {
                val = "Stripe_45";
                break;
            }
            case 8: {
                val = "Stripe_135";
                break;
            }
            case 9: {
                val = "Diag_Hatched";
                break;
            }
            case 10: {
                val = "Cross_Hatched";
                break;
            }
            case 11: {
                val = "Custom_Fill";
                break;
            }
            case 12: {
                val = "Custom_Stack";
            }
        }
        ps.println(this.getNameValueFormat("data" + dataIndex + ".series" + seriesIndex + ".fill.pattern", val));
    }

    private void printTriggers(PrintStream ps) {
        for (int i = 0; i < this.chart.getNumTriggers(); ++i) {
            EventTrigger et = this.chart.getTrigger(i);
            String modifier = "";
            String action = "";
            switch (et.getModifiers()) {
                case 0: {
                    modifier = "None";
                    break;
                }
                case 1: {
                    modifier = "Shift";
                    break;
                }
                case 2: {
                    modifier = "Ctrl";
                    break;
                }
                case 3: {
                    modifier = "Alt";
                    break;
                }
                case 4: {
                    modifier = "Meta";
                }
            }
            switch (et.getAction()) {
                case 6: {
                    action = "CustomizeTrigger";
                    break;
                }
                case 5: {
                    action = "DepthTrigger";
                    break;
                }
                case 3: {
                    action = "EditTrigger";
                    break;
                }
                case -1: {
                    action = "NoneTrigger";
                    break;
                }
                case 4: {
                    action = "PickTrigger";
                    break;
                }
                case 0: {
                    action = "RotateTrigger";
                    break;
                }
                case 2: {
                    action = "TranslateTrigger";
                    break;
                }
                case 1: {
                    action = "ZoomTrigger";
                }
            }
            ps.println(this.getNameValueFormat(action, modifier));
        }
    }

    private void printChartStyle(PrintStream ps) {
        ps.println(this.getNameValueFormat("allowUserChanges", String.valueOf(this.chart.getAllowUserChanges())));
        ps.println(this.getNameValueFormat("width", String.valueOf(this.chart.getWidth())));
        ps.println(this.getNameValueFormat("height", String.valueOf(this.chart.getHeight())));
        Color bg = this.chart.getBackground();
        ps.println(this.getNameValueFormat("background", "" + bg.getRed() + "-" + bg.getGreen() + "-" + bg.getBlue()));
        bg = this.chart.getForeground();
        ps.println(this.getNameValueFormat("foreground", "" + bg.getRed() + "-" + bg.getGreen() + "-" + bg.getBlue()));
        if (this.chart.getFont() != null) {
            ps.println(this.getNameValueFormat("font", this.fontToString(this.chart.getFont())));
        }
        if (this.chart.getBorder() != null) {
            ps.println(this.getNameValueFormat("border", this.borderToString(this.chart.getBorder())));
        }
    }

    private void printLegend(JCLegend legend, PrintStream ps) {
        ps.println(this.getNameValueFormat("legend.orientation", legend.getOrientation() == 1 ? "Vertical" : "Horizontal"));
    }

    private void printJComponent(JComponent com, String prop, PrintStream ps) {
        Color bg = com.getBackground();
        ps.println(this.getNameValueFormat(prop + ".background", "" + bg.getRed() + "-" + bg.getGreen() + "-" + bg.getBlue()));
        bg = com.getForeground();
        ps.println(this.getNameValueFormat(prop + ".foreground", "" + bg.getRed() + "-" + bg.getGreen() + "-" + bg.getBlue()));
        ps.println(this.getNameValueFormat(prop + ".opaque", String.valueOf(com.isOpaque())));
        ps.println(this.getNameValueFormat(prop + ".visible", String.valueOf(com.isVisible())));
        ps.println(this.getNameValueFormat(prop + ".width", String.valueOf(com.getWidth())));
        ps.println(this.getNameValueFormat(prop + ".height", String.valueOf(com.getHeight())));
        ps.println(this.getNameValueFormat(prop + ".isShowing", String.valueOf(com.isShowing())));
        if (com.getFont() != null) {
            ps.println(this.getNameValueFormat(prop + ".font", this.fontToString(com.getFont())));
        }
        if (com.getBorder() != null) {
            ps.println(this.getNameValueFormat(prop + ".border", this.borderToString(com.getBorder())));
        }
    }

    private void printJLabel(JLabel jLabel, String prop, PrintStream ps) {
        ps.println(this.getNameValueFormat(prop + ".text", jLabel.getText()));
        if (jLabel.getFont() != null) {
            ps.println(this.getNameValueFormat(prop + ".font", this.fontToString(jLabel.getFont())));
        }
    }

    private void printAxesStyle(List list, String axisName, PrintStream ps) {
        Color bg = null;
        for (int i = 0; i < list.size(); ++i) {
            long tu;
            JCAxis axis = (JCAxis)list.get(i);
            JCAxisFormula formula = axis.getFormula();
            String name = new String(axisName);
            if (i > 0) {
                axisName = axisName + i;
            }
            if (formula != null) {
                ps.println(this.getNameValueFormat(axisName + ".formula.constant", String.valueOf(formula.getConstant())));
                ps.println(this.getNameValueFormat(axisName + ".formula.multiplier", String.valueOf(formula.getMultiplier())));
                if (formula.getOriginator() != null) {
                    int j = list.indexOf(formula.getOriginator());
                    ps.println(this.getNameValueFormat(axisName + ".formula.originator", name + (j == 0 ? "" : String.valueOf(j))));
                }
            }
            if ((bg = axis.getBackground()) != null) {
                ps.println(this.getNameValueFormat(axisName + ".background", "" + bg.getRed() + "-" + bg.getGreen() + "-" + bg.getBlue()));
            }
            if ((bg = axis.getForeground()) != null) {
                ps.println(this.getNameValueFormat(axisName + ".foreground", "" + bg.getRed() + "-" + bg.getGreen() + "-" + bg.getBlue()));
            }
            switch (axis.getAnnotationMethod()) {
                case 0: {
                    ps.println(this.getNameValueFormat(axisName + ".annotationMethod", "VALUE"));
                    break;
                }
                case 1: {
                    ps.println(this.getNameValueFormat(axisName + ".annotationMethod", "VALUE_LABELS"));
                    break;
                }
                case 2: {
                    ps.println(this.getNameValueFormat(axisName + ".annotationMethod", "TIME_LABELS"));
                    break;
                }
                case 3: {
                    ps.println(this.getNameValueFormat(axisName + ".annotationMethod", "POINT_LABELS"));
                }
            }
            ps.println(this.getNameValueFormat(axisName + ".gap", String.valueOf(axis.getGap())));
            if (axis.getFont() != null) {
                ps.println(this.getNameValueFormat(axisName + ".font", this.fontToString(axis.getFont())));
            }
            if ((tu = axis.getTimeUnit()) == 1000L) {
                ps.println(this.getNameValueFormat(axisName + ".timeUnit", "SECONDS"));
            } else if (tu == 60000L) {
                ps.println(this.getNameValueFormat(axisName + ".timeUnit", "MINUTES"));
            } else if (tu == 3600000L) {
                ps.println(this.getNameValueFormat(axisName + ".timeUnit", "HOURS"));
            } else if (tu == 86400000L) {
                ps.println(this.getNameValueFormat(axisName + ".timeUnit", "DAYS"));
            } else if (tu == 604800000L) {
                ps.println(this.getNameValueFormat(axisName + ".timeUnit", "WEEKS"));
            } else if (tu == 2678400000L) {
                ps.println(this.getNameValueFormat(axisName + ".timeUnit", "MONTHS"));
            } else if (tu == 31536000000L) {
                ps.println(this.getNameValueFormat(axisName + ".timeUnit", "YEARS"));
            }
            JCAxisTitle axisTitle = axis.getTitle();
            if (axisTitle != null) {
                if (axisTitle.getFont() != null) {
                    ps.println(this.getNameValueFormat(axisName + ".title.font", this.fontToString(axisTitle.getFont())));
                }
                if (axisTitle.getText() != null && !axisTitle.getText().equalsIgnoreCase("")) {
                    ps.println(this.getNameValueFormat(axisName + ".title.text", axisTitle.getText()));
                }
                if ((bg = axisTitle.getBackground()) != null) {
                    ps.println(this.getNameValueFormat(axisName + ".title.background", "" + bg.getRed() + "-" + bg.getGreen() + "-" + bg.getBlue()));
                }
                if ((bg = axisTitle.getForeground()) != null) {
                    ps.println(this.getNameValueFormat(axisName + ".title.foreground", "" + bg.getRed() + "-" + bg.getGreen() + "-" + bg.getBlue()));
                }
                ps.println(this.getNameValueFormat(axisName + ".title.visible", String.valueOf(axisTitle.isVisible())));
            }
            switch (axis.getAnnotationRotation()) {
                case 1: {
                    ps.println(this.getNameValueFormat(axisName + ".annotationRotation", "90"));
                    break;
                }
                case 2: {
                    ps.println(this.getNameValueFormat(axisName + ".annotationRotation", "180"));
                    break;
                }
                case 3: {
                    ps.println(this.getNameValueFormat(axisName + ".annotationRotation", "270"));
                    break;
                }
                default: {
                    ps.println(this.getNameValueFormat(axisName + ".annotationRotation", "0"));
                }
            }
            ps.println(this.getNameValueFormat(axisName + ".gridSpacing", String.valueOf(axis.getGridSpacing())));
            ps.println(this.getNameValueFormat(axisName + ".editable", String.valueOf(axis.isEditable())));
            ps.println(this.getNameValueFormat(axisName + ".logarithmic", String.valueOf(axis.isLogarithmic())));
            ps.println(this.getNameValueFormat(axisName + ".reversed", String.valueOf(axis.isReversed())));
            ps.println(this.getNameValueFormat(axisName + ".visible", String.valueOf(axis.isVisible())));
            ps.println(this.getNameValueFormat(axisName + ".min", String.valueOf(axis.getMin())));
            ps.println(this.getNameValueFormat(axisName + ".max", String.valueOf(axis.getMax())));
            ps.println(this.getNameValueFormat(axisName + ".numSpacing", String.valueOf(axis.getNumSpacing())));
            ps.println(this.getNameValueFormat(axisName + ".origin", String.valueOf(axis.getOrigin())));
            ps.println(this.getNameValueFormat(axisName + ".placementLocation", String.valueOf(axis.getPlacementLocation())));
            ps.println(this.getNameValueFormat(axisName + ".precision", String.valueOf(axis.getPrecision())));
            ps.println(this.getNameValueFormat(axisName + ".tickSpacing", String.valueOf(axis.getTickSpacing())));
            ps.println(this.getNameValueFormat(axisName + ".timeBase", String.valueOf(axis.getTimeBase())));
            ps.println(this.getNameValueFormat(axisName + ".timeFormat", String.valueOf(axis.getTimeFormat())));
        }
    }

    public void loadChartStyleFile(OpenitChart openitChart) {
        JFileChooser fc = new JFileChooser();
        int command = fc.showOpenDialog(null);
        if (command == 0) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(fc.getSelectedFile()));
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger((1.class$com$openit$chart$ChartStyleLoader == null ? (1.class$com$openit$chart$ChartStyleLoader = 1.class$("com.openit.chart.ChartStyleLoader")) : 1.class$com$openit$chart$ChartStyleLoader).getName()).log(Level.SEVERE, null, ex);
            }
            try {
                this.loadStyle(br, openitChart);
            }
            catch (IOException ex) {
                Logger.getLogger((1.class$com$openit$chart$ChartStyleLoader == null ? (1.class$com$openit$chart$ChartStyleLoader = 1.class$("com.openit.chart.ChartStyleLoader")) : 1.class$com$openit$chart$ChartStyleLoader).getName()).log(Level.SEVERE, null, ex);
            }
        } else if (command == 1 || command == -1) {
            // empty if block
        }
    }

    private void loadStyle(BufferedReader br, OpenitChart openitChart) throws IOException {
        String line = br.readLine();
        while (line != null) {
            String paramName = this.getParamName(line).trim();
            String paramValue = this.getParamValue(line).trim();
            if (paramName.indexOf("chartArea") != -1) {
                JCChartArea chartArea = this.chart.getChartArea();
                if (paramName.indexOf("background") != -1) {
                    chartArea.setBackground(this.getRGB(paramValue));
                } else if (paramName.indexOf("foreground") != -1) {
                    chartArea.setForeground(this.getRGB(paramValue));
                } else if (paramName.indexOf("opaque") != -1) {
                    chartArea.setOpaque(Boolean.valueOf(paramValue).booleanValue());
                } else if (paramName.indexOf("visible") != -1) {
                    chartArea.setVisible(Boolean.valueOf(paramValue).booleanValue());
                } else if (paramName.indexOf("width") != -1) {
                    chartArea.setSize(Integer.parseInt(paramValue), chartArea.getHeight());
                } else if (paramName.indexOf("height") != -1) {
                    chartArea.setSize(chartArea.getWidth(), Integer.parseInt(paramValue));
                } else if (paramName.indexOf("showing") == -1) {
                    if (paramName.indexOf("font") != -1) {
                        chartArea.setFont(this.stringToFont(paramValue));
                    } else if (paramName.indexOf("border") != -1) {
                        chartArea.setBorder(this.stringToBorder(paramValue));
                    }
                }
            } else if (paramName.indexOf("data") != -1) {
                List dataView = this.chart.getDataView();
                String[] temp = paramName.split("data");
                int dataIndex = Integer.parseInt("" + temp[1].charAt(0));
                ChartDataView cDataView = (ChartDataView)dataView.get(dataIndex);
                if (paramName.indexOf("inverted") != -1) {
                    cDataView.setInverted(Boolean.valueOf(paramValue).booleanValue());
                } else if (paramName.indexOf("holeValue") != -1) {
                    cDataView.setHoleValue((double)Float.parseFloat(paramValue));
                } else if (paramName.indexOf("chartType") != -1) {
                    if (paramValue.equalsIgnoreCase("AREA")) {
                        cDataView.setChartType(8);
                    } else if (paramValue.equalsIgnoreCase("STACKING_AREA")) {
                        cDataView.setChartType(12);
                    } else if (paramValue.equalsIgnoreCase("BAR")) {
                        cDataView.setChartType(9);
                    } else if (paramValue.equalsIgnoreCase("STACKING_BAR")) {
                        cDataView.setChartType(10);
                    } else if (paramValue.equalsIgnoreCase("PLOT")) {
                        cDataView.setChartType(0);
                    } else if (paramValue.equalsIgnoreCase("SCATTER_PLOT")) {
                        cDataView.setChartType(1);
                    } else if (paramValue.equalsIgnoreCase("PIE")) {
                        cDataView.setChartType(11);
                    }
                } else if (paramName.indexOf("series") != -1) {
                    temp = paramName.split("series");
                    int index = Integer.parseInt("" + temp[1].split("\\.")[0]);
                    if (index < cDataView.getSeries().size()) {
                        ChartDataViewSeries series = cDataView.getSeries(index);
                        JCChartStyle style = series.getStyle();
                        if (paramName.indexOf("symbol") != -1) {
                            if (paramName.indexOf("shape") != -1) {
                                if (paramValue.equalsIgnoreCase("None")) {
                                    style.setSymbolShape(0);
                                } else if (paramValue.equalsIgnoreCase("Dot")) {
                                    style.setSymbolShape(1);
                                } else if (paramValue.equalsIgnoreCase("Box")) {
                                    style.setSymbolShape(2);
                                } else if (paramValue.equalsIgnoreCase("Triangle")) {
                                    style.setSymbolShape(3);
                                } else if (paramValue.equalsIgnoreCase("Diamond")) {
                                    style.setSymbolShape(4);
                                } else if (paramValue.equalsIgnoreCase("Star")) {
                                    style.setSymbolShape(5);
                                } else if (paramValue.equalsIgnoreCase("Vert_Line")) {
                                    style.setSymbolShape(6);
                                } else if (paramValue.equalsIgnoreCase("Horiz_Line")) {
                                    style.setSymbolShape(7);
                                } else if (paramValue.equalsIgnoreCase("Cross")) {
                                    style.setSymbolShape(8);
                                } else if (paramValue.equalsIgnoreCase("Circle")) {
                                    style.setSymbolShape(9);
                                } else if (paramValue.equalsIgnoreCase("Square")) {
                                    style.setSymbolShape(10);
                                }
                            } else if (paramName.indexOf("color") != -1) {
                                style.setSymbolColor(this.getRGB(paramValue));
                            } else if (paramName.indexOf("size") != -1) {
                                style.setSymbolSize(Integer.parseInt(paramValue));
                            }
                        } else if (paramName.indexOf("line") != -1) {
                            if (paramName.indexOf("color") != -1) {
                                style.setLineColor(this.getRGB(paramValue));
                            } else if (paramName.indexOf("width") != -1) {
                                style.setLineWidth(Integer.parseInt(paramValue));
                            } else if (paramName.indexOf("pattern") != -1) {
                                if (paramValue.equalsIgnoreCase("Solid")) {
                                    style.setLinePattern(1);
                                } else if (paramValue.equalsIgnoreCase("LSL_Dash")) {
                                    style.setLinePattern(4);
                                }
                                if (paramValue.equalsIgnoreCase("Dash_Dot")) {
                                    style.setLinePattern(5);
                                } else if (paramValue.equalsIgnoreCase("Long_Dash")) {
                                    style.setLinePattern(2);
                                } else if (paramValue.equalsIgnoreCase("Short_Dash")) {
                                    style.setLinePattern(3);
                                } else if (paramValue.equalsIgnoreCase("None")) {
                                    style.setLinePattern(0);
                                }
                            } else if (paramName.indexOf("join") != -1) {
                                if (paramValue.equalsIgnoreCase("Miter")) {
                                    style.setLineJoin(0);
                                } else if (paramValue.equalsIgnoreCase("Bevel")) {
                                    style.setLineJoin(2);
                                } else if (paramValue.equalsIgnoreCase("Round")) {
                                    style.setLineJoin(1);
                                }
                            } else if (paramName.indexOf("cap") != -1) {
                                if (paramValue.equalsIgnoreCase("Butt")) {
                                    style.setLineCap(0);
                                } else if (paramValue.equalsIgnoreCase("Round")) {
                                    style.setLineCap(1);
                                } else if (paramValue.equalsIgnoreCase("Square")) {
                                    style.setLineCap(2);
                                }
                            }
                        } else if (paramName.indexOf("fill") != -1) {
                            if (paramName.indexOf("color") != -1) {
                                style.setFillColor(this.getRGB(paramValue));
                            } else if (paramName.indexOf("background") != -1) {
                                style.setFillBackground(this.getRGB(paramValue));
                            } else if (paramName.indexOf("pattern") != -1) {
                                if (paramValue.equalsIgnoreCase("Cross_Hatched")) {
                                    style.setFillPattern(10);
                                } else if (paramValue.equalsIgnoreCase("Custom_Stack")) {
                                    style.setFillPattern(12);
                                } else if (paramValue.equalsIgnoreCase("Diag_Hatched")) {
                                    style.setFillPattern(9);
                                } else if (paramValue.equalsIgnoreCase("Horiz_Stripe")) {
                                    style.setFillPattern(5);
                                } else if (paramValue.equalsIgnoreCase("None")) {
                                    style.setFillPattern(0);
                                } else if (paramValue.equalsIgnoreCase("Per_25")) {
                                    style.setFillPattern(2);
                                } else if (paramValue.equalsIgnoreCase("Per_50")) {
                                    style.setFillPattern(3);
                                } else if (paramValue.equalsIgnoreCase("Per_75")) {
                                    style.setFillPattern(4);
                                } else if (paramValue.equalsIgnoreCase("Solid")) {
                                    style.setFillPattern(1);
                                } else if (paramValue.equalsIgnoreCase("Stripe_135")) {
                                    style.setFillPattern(8);
                                } else if (paramValue.equalsIgnoreCase("Stripe_45")) {
                                    style.setFillPattern(7);
                                } else if (paramValue.equalsIgnoreCase("Vert_Stripe")) {
                                    style.setFillPattern(6);
                                }
                            }
                        }
                    }
                }
            } else if (paramName.indexOf("header") != -1 || paramName.indexOf("footer") != -1) {
                JComponent com = paramName.indexOf("header") != -1 ? this.chart.getHeader() : this.chart.getFooter();
                if (paramName.indexOf("background") != -1) {
                    com.setBackground(this.getRGB(paramValue));
                } else if (paramName.indexOf("foreground") != -1) {
                    com.setForeground(this.getRGB(paramValue));
                } else if (paramName.indexOf("opaque") != -1) {
                    com.setOpaque(Boolean.valueOf(paramValue));
                } else if (paramName.indexOf("visible") != -1) {
                    com.setVisible(Boolean.valueOf(paramValue));
                } else if (paramName.indexOf("width") != -1) {
                    com.setSize(Integer.parseInt(paramValue), com.getHeight());
                } else if (paramName.indexOf("height") != -1) {
                    com.setSize(com.getWidth(), Integer.parseInt(paramValue));
                } else if (paramName.indexOf("font") != -1) {
                    com.setFont(this.stringToFont(paramValue));
                } else if (paramName.indexOf("border") != -1) {
                    com.setBorder(this.stringToBorder(paramValue));
                }
            } else if (paramName.indexOf("plotArea") != -1) {
                PlotArea plotArea = this.chart.getChartArea().getPlotArea();
                if (paramName.indexOf("background") != -1) {
                    plotArea.setBackground(this.getRGB(paramValue));
                } else if (paramName.indexOf("foreground") != -1) {
                    plotArea.setForeground(this.getRGB(paramValue));
                }
            } else if (paramName.indexOf("legend") != -1) {
                JCLegend legend = this.chart.getLegend();
                if (paramName.indexOf("background") != -1) {
                    legend.setBackground(this.getRGB(paramValue));
                } else if (paramName.indexOf("foreground") != -1) {
                    legend.setForeground(this.getRGB(paramValue));
                } else if (paramName.indexOf("font") != -1) {
                    legend.setFont(this.stringToFont(paramValue));
                } else if (paramName.indexOf("width") != -1) {
                    legend.setSize(Integer.parseInt(paramValue), legend.getHeight());
                } else if (paramName.indexOf("heigth") != -1) {
                    legend.setSize(legend.getWidth(), Integer.parseInt(paramValue));
                } else if (paramName.indexOf("isShowing") == -1) {
                    if (paramName.indexOf("visible") != -1) {
                        legend.setVisible(Boolean.valueOf(paramValue).booleanValue());
                    } else if (paramName.indexOf("orientation") != -1) {
                        if (paramValue.equalsIgnoreCase("Horizontal")) {
                            legend.setOrientation(0);
                        } else if (paramValue.equalsIgnoreCase("Vertical")) {
                            legend.setOrientation(1);
                        }
                    } else if (paramName.indexOf("border") != -1) {
                        legend.setBorder(this.stringToBorder(paramValue));
                    }
                }
            } else if (paramName.indexOf("axis") != -1) {
                int index;
                try {
                    index = Integer.parseInt(String.valueOf(paramName.charAt(paramName.length() - 1)));
                }
                catch (NumberFormatException ex) {
                    index = -1;
                }
                List axes = null;
                if (paramName.indexOf("xaxis") != -1) {
                    axes = this.chart.getChartArea().getXAxes();
                } else if (paramName.indexOf("yaxis") != -1) {
                    axes = this.chart.getChartArea().getYAxes();
                }
                JCAxis axis = (JCAxis)axes.get(0);
                if (index != -1) {
                    axis = (JCAxis)axes.get(index);
                }
                if (paramName.indexOf("formula") != -1) {
                    JCAxisFormula formula = axis.getFormula();
                    if (formula != null) {
                        if (paramName.indexOf("constant") != -1) {
                            formula.setConstant(Double.parseDouble(paramValue));
                        } else if (paramName.indexOf("multiplier") != -1) {
                            formula.setMultiplier(Double.parseDouble(paramValue));
                        } else if (paramName.indexOf("originator") != -1) {
                            try {
                                index = Integer.parseInt(String.valueOf(paramValue.charAt(paramName.length())));
                            }
                            catch (NumberFormatException ex) {
                                index = 0;
                            }
                            formula.setOriginator((JCAxis)axes.get(index));
                        }
                    }
                } else if (paramName.indexOf("foreground") != -1) {
                    axis.setForeground(this.getRGB(paramValue));
                } else if (paramName.indexOf("annotationMethod") == -1) {
                    if (paramName.indexOf("annotationRotation") != -1) {
                        int rotation = Integer.parseInt(paramValue);
                        switch (rotation) {
                            case 90: {
                                axis.setAnnotationRotation(1);
                                break;
                            }
                            case 270: {
                                axis.setAnnotationRotation(3);
                                break;
                            }
                            case 180: {
                                axis.setAnnotationRotation(2);
                                break;
                            }
                            default: {
                                axis.setAnnotationRotation(0);
                                break;
                            }
                        }
                    } else if (paramName.indexOf("gap") != -1) {
                        axis.setGap(Integer.parseInt(paramValue));
                    } else if (paramName.indexOf("font") != -1) {
                        axis.setFont(this.stringToFont(paramValue));
                    } else if (paramName.indexOf("timeUnit") == -1) {
                        if (paramName.indexOf("gridSpacing") != -1) {
                            axis.setGridSpacing(Double.parseDouble(paramValue));
                        } else if (paramName.indexOf("editable") != -1) {
                            axis.setEditable(Boolean.valueOf(paramValue).booleanValue());
                        } else if (paramName.indexOf("logarithmic") != -1) {
                            axis.setLogarithmic(Boolean.valueOf(paramValue).booleanValue());
                        } else if (paramName.indexOf("reversed") != -1) {
                            axis.setReversed(Boolean.valueOf(paramValue).booleanValue());
                        } else if (paramName.indexOf("visible") != -1) {
                            axis.setVisible(Boolean.valueOf(paramValue).booleanValue());
                        } else if (paramName.indexOf(".min") == -1) {
                            if (paramName.indexOf(".max") != -1) {
                                axis.setMax(Double.parseDouble(paramValue));
                            } else if (paramName.indexOf("numSpacing") != -1) {
                                axis.setNumSpacing(Double.parseDouble(paramValue));
                            } else if (paramName.indexOf("origin") == -1) {
                                if (paramName.indexOf("placementLocation") != -1) {
                                    axis.setPlacementLocation(Double.parseDouble(paramValue));
                                } else if (paramName.indexOf("precision") != -1) {
                                    axis.setPrecision(Integer.parseInt(paramValue));
                                } else if (paramName.indexOf("tickSpacing") != -1) {
                                    axis.setTickSpacing(Double.parseDouble(paramValue));
                                } else if (paramName.indexOf("timeBase") == -1 && paramName.indexOf("timeFormat") != -1) {
                                    axis.setTimeFormat(paramValue);
                                }
                            }
                        }
                    }
                }
            } else if (paramName.indexOf(".") == -1) {
                if (paramName.indexOf("background") != -1) {
                    this.chart.setBackground(this.getRGB(paramValue));
                } else if (paramName.indexOf("foreground") != -1) {
                    this.chart.setForeground(this.getRGB(paramValue));
                } else if (paramName.indexOf("allowUserChanges") != -1) {
                    this.chart.setAllowUserChanges(Boolean.valueOf(paramValue).booleanValue());
                } else if (paramName.indexOf("width") != -1) {
                    this.chart.setSize(Integer.parseInt(paramValue), this.chart.getHeight());
                } else if (paramName.indexOf("height") != -1) {
                    this.chart.setSize(this.chart.getWidth(), Integer.parseInt(paramValue));
                } else if (paramName.indexOf("font") != -1) {
                    this.chart.setFont(this.stringToFont(paramValue));
                } else if (paramName.indexOf("border") != -1) {
                    this.chart.setBorder(this.stringToBorder(paramValue));
                } else if (paramName.indexOf("trigger") != -1) {
                    int mod = -1;
                    if (paramName.equalsIgnoreCase("None")) {
                        mod = 0;
                    } else if (paramName.equalsIgnoreCase("Shift")) {
                        mod = 1;
                    } else if (paramName.equalsIgnoreCase("Ctrl")) {
                        mod = 2;
                    } else if (paramName.equalsIgnoreCase("Alt")) {
                        mod = 3;
                    } else if (paramName.equalsIgnoreCase("Meta")) {
                        mod = 4;
                    }
                    int action = -1;
                    if (paramName.indexOf("CustomizeTrigger") != -1) {
                        action = 6;
                    }
                    if (paramName.indexOf("DepthTrigger") != -1) {
                        action = 5;
                    }
                    if (paramName.indexOf("EditTrigger") != -1) {
                        action = 3;
                    }
                    if (paramName.indexOf("PickTrigger") != -1) {
                        action = 4;
                    }
                    if (paramName.indexOf("RotateTrigger") != -1) {
                        action = 0;
                    }
                    if (paramName.indexOf("TranslateTrigger") != -1) {
                        action = 2;
                    }
                    if (paramName.indexOf("ZoomTrigger") != -1) {
                        action = 1;
                    }
                    this.chart.addTrigger(mod, action);
                }
            }
            line = br.readLine();
        }
    }

    private String fontToString(Font font) {
        String name = font.getFamily();
        String styleString = "";
        int style = font.getStyle();
        int size = font.getSize();
        if ((style & 1) == 1 || (style & 2) == 2) {
            if ((style & 1) == 1) {
                styleString = styleString + "BOLD";
            }
            if ((style & 2) == 2) {
                styleString = styleString + "ITALIC";
            }
        } else if ((style & 0) == 0) {
            styleString = styleString + "PLAIN";
        }
        return name + "-" + styleString + "-" + size;
    }

    private Font stringToFont(String param) {
        String[] params = param.split("-");
        int style = 0;
        int size = Integer.parseInt(params[2]);
        if (params[1].indexOf("BOLD") != -1) {
            style |= 1;
        }
        if (params[1].indexOf("PLAIN") != -1) {
            style |= 0;
        }
        if (params[1].indexOf("ITALIC") != -1) {
            style |= 2;
        }
        return new Font(params[0], style, size);
    }

    private Color getRGB(String paramValue) {
        if (!paramValue.equalsIgnoreCase("null")) {
            String[] rgb = paramValue.split("-");
            Color c = new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
            return c;
        }
        return null;
    }

    private String getRGBString(Color c) {
        if (c != null) {
            return c.getRed() + "-" + c.getGreen() + "-" + c.getBlue();
        }
        return null;
    }

    private String getParamName(String line) {
        String value = line.split("NAME*=")[1];
        return value.split("\"*\"")[1];
    }

    private String getParamValue(String line) {
        String value = line.split("VALUE*=")[1];
        return value.split("\"*\"")[1];
    }

    private String getNameValueFormat(String name, String value) {
        return new String("<PARAM NAME=\"" + name + "\" VALUE=\"" + value + "\">");
    }

    private Border stringToBorder(String param) {
        String type = param.split("\\|")[0];
        if (type.equalsIgnoreCase("empty")) {
            return this.getEmptyBorder(param);
        }
        if (type.equalsIgnoreCase("softbevel")) {
            return this.getSoftBevelBorder(param);
        }
        if (type.equalsIgnoreCase("bevel")) {
            return this.getBevelBorder(param);
        }
        if (type.equalsIgnoreCase("etched")) {
            return this.getEtchedBorder(param);
        }
        if (type.equalsIgnoreCase("line")) {
            return this.getLineBorder(param);
        }
        if (type.equalsIgnoreCase("titled")) {
            return this.getTitledBorder(param);
        }
        return null;
    }

    private EmptyBorder getEmptyBorder(String param) {
        String[] vals = param.split("\\|");
        Insets insets = new Insets(Integer.parseInt(vals[1]), Integer.parseInt(vals[2]), Integer.parseInt(vals[3]), Integer.parseInt(vals[4]));
        BorderUIResource.EmptyBorderUIResource border = new BorderUIResource.EmptyBorderUIResource(insets);
        return border;
    }

    private SoftBevelBorder getSoftBevelBorder(String param) {
        String[] vals = param.split("\\|");
        int type = vals[1].equalsIgnoreCase("lowered") ? 1 : 0;
        SoftBevelBorder border = new SoftBevelBorder(type, this.getRGB(vals[2]), this.getRGB(vals[3]));
        return border;
    }

    private BevelBorder getBevelBorder(String param) {
        String[] vals = param.split("\\|");
        int type = vals[1].equalsIgnoreCase("lowered") ? 1 : 0;
        BevelBorder border = new BevelBorder(type, this.getRGB(vals[2]), this.getRGB(vals[3]));
        return border;
    }

    private EtchedBorder getEtchedBorder(String param) {
        String[] vals = param.split("\\|");
        int type = vals[1].equalsIgnoreCase("lowered") ? 1 : 0;
        EtchedBorder border = new EtchedBorder(type, this.getRGB(vals[2]), this.getRGB(vals[3]));
        return border;
    }

    private LineBorder getLineBorder(String param) {
        String[] vals = param.split("\\|");
        Color c = this.getRGB(vals[1]);
        int thick = Integer.parseInt(vals[2]);
        LineBorder border = new LineBorder(c, thick);
        return border;
    }

    private TitledBorder getTitledBorder(String param) {
        String[] title = param.split("\\|");
        TitledBorder border = new TitledBorder(title[1]);
        return border;
    }

    private String borderToString(Border border) {
        if (border instanceof EmptyBorder) {
            return this.getEmptyBorder((EmptyBorder)border);
        }
        if (border instanceof SoftBevelBorder) {
            return this.getSoftBevelBorder((SoftBevelBorder)border);
        }
        if (border instanceof BevelBorder) {
            return this.getBevelBorder((BevelBorder)border);
        }
        if (border instanceof EtchedBorder) {
            return this.getEtchedBorder((EtchedBorder)border);
        }
        if (border instanceof LineBorder) {
            return this.getLineBorder((LineBorder)border);
        }
        if (border instanceof TitledBorder) {
            return this.getTitledBorder((TitledBorder)border);
        }
        return null;
    }

    private String getEmptyBorder(EmptyBorder border) {
        String name = "empty";
        Insets insets = border.getBorderInsets();
        name = name + "|" + insets.top + "|" + insets.left + "|" + insets.bottom + "|" + insets.right;
        return name;
    }

    private String getTitledBorder(TitledBorder border) {
        String name = "titled";
        String title = border.getTitle();
        name = name + "|" + title;
        return name;
    }

    private String getLineBorder(LineBorder border) {
        String name = "softbevel";
        String color = this.getRGBString(border.getLineColor());
        int thick = border.getThickness();
        name = name + "|" + color;
        name = name + "|" + thick;
        return name;
    }

    private String getSoftBevelBorder(SoftBevelBorder border) {
        String name = "softbevel";
        String type = border.getBevelType() == 1 ? "lowered" : "raised";
        String highlight = this.getRGBString(border.getHighlightInnerColor());
        String shadow = this.getRGBString(border.getShadowInnerColor());
        name = name + "|" + type;
        if (highlight != null) {
            name = name + "|" + highlight;
        }
        if (shadow != null) {
            name = name + "|" + shadow;
        }
        return name;
    }

    private String getBevelBorder(BevelBorder border) {
        String name = "bevel";
        String type = border.getBevelType() == 1 ? "lowered" : "raised";
        String highlight = this.getRGBString(border.getHighlightInnerColor());
        String shadow = this.getRGBString(border.getShadowInnerColor());
        name = name + "|" + type;
        if (highlight != null) {
            name = name + "|" + highlight;
        }
        if (shadow != null) {
            name = name + "|" + shadow;
        }
        return name;
    }

    private String getEtchedBorder(EtchedBorder border) {
        String name = "etched";
        String type = border.getEtchType() == 1 ? "lowered" : "raised";
        String highlight = this.getRGBString(border.getHighlightColor());
        String shadow = this.getRGBString(border.getShadowColor());
        name = name + "|" + type;
        if (highlight != null) {
            name = name + "|" + highlight;
        }
        if (shadow != null) {
            name = name + "|" + shadow;
        }
        return name;
    }

    static class 1 {
        static /* synthetic */ Class class$com$openit$chart$OpenitChart;
        static /* synthetic */ ClassLoader cl$;
        static /* synthetic */ Class class$com$openit$chart$ChartStyleLoader;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0, false, cl$ == null ? (cl$ = new 1[0].getClass().getComponentType().getClassLoader()) : cl$);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError().initCause(x1);
            }
        }
    }
}

