/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartInteriorRegion;
import com.klg.jclass.chart.ChartRegion;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.CellRendererPane;

public class ChartText
extends ChartInteriorRegion
implements Serializable {
    protected int adjust = 1;
    protected int rotation = 0;
    protected String text = null;
    protected JCAxis parentAxis = null;
    protected static TextRenderer rendComp = new TextRenderer();
    protected transient Image buffer;
    boolean isHTML = false;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEG_0 = 0;
    public static final int DEG_90 = 1;
    public static final int DEG_180 = 2;
    public static final int DEG_270 = 3;

    public ChartText() {
    }

    public ChartText(JCChart jCChart, String string, JCAxis jCAxis) {
        this.setParentAxis(jCAxis);
        this.setText(string);
        this.setParentChart(jCChart);
    }

    public ChartText(JCChart jCChart, String string, ChartRegion chartRegion) {
        this.setParentRegion(chartRegion);
        this.setText(string);
        this.setParentChart(jCChart);
    }

    void setParentAxis(JCAxis jCAxis) {
        this.parentAxis = jCAxis;
    }

    public FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = this.parentChart.getGraphics() != null ? this.parentChart.getGraphics().getFontMetrics(font) : this.parentChart.getToolkit().getFontMetrics(font);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fontMetrics;
    }

    public void draw(Graphics graphics) {
        if (!this.visible || graphics == null || this.parentChart == null) {
            return;
        }
        boolean bl = this.transparent;
        if (this.transparent && this.background != null) {
            this.transparent = false;
        }
        super.draw(graphics);
        this.transparent = bl;
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.getDrawingArea();
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (this.text != null && fontMetrics != null) {
            Graphics2D graphics2D = (Graphics2D)graphics2;
            if (this.rotation == 1) {
                graphics2D.translate(rectangle.width, 0);
                graphics2D.rotate(1.5707963267948966, rectangle.x, rectangle.y);
            } else if (this.rotation == 2) {
                graphics2D.translate(rectangle.width, rectangle.height);
                graphics2D.rotate(Math.PI, rectangle.x, rectangle.y);
            } else if (this.rotation == 3) {
                graphics2D.translate(0, rectangle.height + 1);
                graphics2D.rotate(4.71238898038469, rectangle.x, rectangle.y);
            }
            if (this.isHTML) {
                ChartRegion chartRegion = this.parentAxis == null ? this.getParentRegion() : this.parentAxis.getParentRegion();
                CellRendererPane cellRendererPane = chartRegion.getCellRendererPane();
                if (cellRendererPane != null) {
                    if (this.rotation == 0 || this.rotation == 2) {
                        rendComp.drawHTMLText(graphics2D, cellRendererPane, chartRegion, this.text, this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
                    } else {
                        rendComp.drawHTMLText(graphics2D, cellRendererPane, chartRegion, this.text, this.getLeft(), this.getTop(), this.getHeight(), this.getWidth());
                    }
                }
            } else if (this.text.length() > 0) {
                graphics2D.drawString(this.text, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
            }
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
        this.setChanged(false, 0);
    }

    public void setRotation(int n) {
        if (n == this.rotation) {
            return;
        }
        this.rotation = n;
        this.setChanged(true, 2);
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getAdjust() {
        return this.adjust;
    }

    public void setAdjust(int n) {
        if (n == this.adjust) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.adjust = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Adjust in ChartText.  Must be one of LEFT, CENTER or RIGHT");
            }
        }
        this.setChanged(true, 1);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.setText(string, true);
    }

    public void setText(String string, boolean bl) {
        this.text = string;
        this.isHTML = JCChartUtil.isHTML(this.text);
        if (bl) {
            this.setVisible(true);
        }
        if (this.parentChart == null) {
            return;
        }
        this.setChanged(true, 2);
    }

    protected void recalc(boolean bl) {
        boolean bl2 = false;
        if (this.isChanged(2)) {
            bl2 = true;
        } else if (!bl) {
            return;
        }
        Dimension dimension = this.calcSize();
        if (dimension.width == 0 || dimension.height == 0) {
            this.setSize(0, 0);
        } else if (this.rotation == 0 || this.rotation == 2) {
            this.setSize(dimension.width, dimension.height);
        } else {
            this.setSize(dimension.height, dimension.width);
        }
        if (bl2) {
            this.setChanged(false, 0);
        }
    }

    public void recalc() {
        this.recalc(false);
    }

    public void setParentChart(JCChart jCChart) {
        super.setParentChart(jCChart);
        this.setChanged(true, 2, false);
        this.recalc();
    }

    protected Dimension calcSize() {
        if (this.isHTML) {
            return rendComp.calcHTMLTextSize(this.text);
        }
        Font font = this.getFont();
        if (font == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics != null) {
            if (this.text == null) {
                return new Dimension(0, fontMetrics.getHeight());
            }
            Dimension dimension = new Dimension(fontMetrics.stringWidth(this.text), fontMetrics.getHeight());
            JCChartUtil.fudgeItalicLabel(font, dimension);
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public Dimension calcLineSize() {
        if (this.isHTML) {
            int n = 1;
            n += JCChartUtil.countInString("<p>", this.text);
            n += JCChartUtil.countInString("<br>", this.text);
            n += JCChartUtil.countInString("<P>", this.text);
            return new Dimension(this.getWidth(), this.getHeight() / (n += JCChartUtil.countInString("<BR>", this.text)));
        }
        Font font = this.getFont();
        if (font == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return new Dimension(this.getWidth(), fontMetrics.getAscent());
    }

    public Color getForeground() {
        Color color = this.foreground;
        if (color == null && this.parentRegion != null) {
            color = this.parentRegion.getForeground();
        }
        if (color == null && this.parentAxis != null) {
            color = this.parentAxis.getForeground();
        }
        if (color == null && this.parentChart != null) {
            color = this.parentChart.getForeground();
        }
        return color;
    }

    public Color getBackground() {
        Color color = this.background;
        if (color == null && this.parentAxis != null) {
            color = this.parentAxis.getBackground();
        }
        if (color == null && this.parentChart != null) {
            color = this.parentChart.isOpaque() ? this.parentChart.getBackground() : null;
        }
        return color;
    }

    public Font getFont() {
        Font font = this.font;
        if (font == null && this.parentAxis != null) {
            font = this.parentAxis.getFont();
        }
        if (font == null && this.parentChart != null) {
            font = this.parentChart.getFont();
        }
        return font;
    }

    public Dimension preferredSize() {
        this.recalc();
        Dimension dimension = this.size();
        return dimension;
    }

    public String toString() {
        if (this.text == null) {
            return super.toString();
        }
        return this.text;
    }
}

