/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.ChartDataSourceUtil;
import com.klg.jclass.chart.data.JCDataInterpreter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;

public class JCDefaultDataInterpreter
extends JCDataInterpreter
implements Serializable {
    private StreamTokenizer tokenizer;
    private final char QUOTE = (char)39;

    public JCDefaultDataInterpreter(BaseDataSource baseDataSource) {
        super(baseDataSource);
    }

    public JCDefaultDataInterpreter() {
    }

    protected void ctor(Reader reader) throws IOException {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(39);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.lowerCaseMode(true);
        this.tokenizer.parseNumbers();
        this.tokenizer.whitespaceChars(43, 43);
        this.init();
        this.tokenizer = null;
    }

    private double getNextDouble() throws IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -2) {
            String string;
            if (this.tokenizer.ttype == -3 && (string = this.tokenizer.sval).equalsIgnoreCase("HOLE")) {
                return this.baseDS.holeValue;
            }
            this.displayErrorMessage(2);
            throw new IOException("Error in data file format - " + this.tokenizer);
        }
        double d = this.tokenizer.nval;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype == -3 && this.tokenizer.sval != null && (this.tokenizer.sval.charAt(0) == 'e' || this.tokenizer.sval.charAt(0) == 'E')) {
            if (this.tokenizer.sval.length() == 1) {
                this.tokenizer.nextToken();
                if (this.tokenizer.ttype == -2) {
                    d *= Math.pow(10.0, this.tokenizer.nval);
                }
            } else {
                String string = this.tokenizer.sval;
                int n = Integer.valueOf(this.tokenizer.sval.substring(1));
                d *= Math.pow(10.0, n);
            }
        } else {
            this.tokenizer.pushBack();
        }
        return d;
    }

    private void displayErrorMessage(int n) {
        boolean bl = true;
        String string = "Error reading data: line " + this.tokenizer.lineno() + ": ";
        switch (n) {
            case 1: {
                string = string + "Data must start with ARRAY or GENERAL and not";
                break;
            }
            case 2: {
                string = string + "Expect either a hole or numeric value and not ";
                break;
            }
            case 3: {
                string = string + "Expect a point label and not ";
                break;
            }
            default: {
                return;
            }
        }
        if (bl) {
            string = this.tokenizer.ttype == 39 ? string + "'" + this.tokenizer.sval + "'" : (this.tokenizer.ttype == -3 ? string + this.tokenizer.sval : (this.tokenizer.ttype == -2 ? string + this.tokenizer.nval : string + this.tokenizer.toString()));
        }
        System.err.println(string);
    }

    private synchronized void init() throws IOException {
        boolean bl;
        boolean bl2 = false;
        if (this.tokenizer.nextToken() != -3) {
            bl2 = true;
        } else if (this.tokenizer.sval.equals("debug") && this.tokenizer.nextToken() != -3) {
            bl2 = true;
        }
        if (bl2 || !this.tokenizer.sval.equals("array") && !this.tokenizer.sval.equals("general")) {
            this.displayErrorMessage(1);
            throw new IOException("Data must start with ARRAY or GENERAL");
        }
        boolean bl3 = false;
        bl3 = this.tokenizer.sval.equals("array");
        if (this.tokenizer.nextToken() == 39) {
            String string = new String(this.tokenizer.sval);
            this.baseDS.name = ChartDataSourceUtil.processText(string);
        } else {
            this.tokenizer.pushBack();
        }
        int n = (int)this.getNextDouble();
        int n2 = (int)this.getNextDouble();
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("t")) {
            bl = true;
        } else {
            bl = false;
            this.tokenizer.pushBack();
        }
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("hole")) {
            this.baseDS.holeValue = this.getNextDouble();
        } else {
            this.tokenizer.pushBack();
        }
        if (bl3) {
            this.readArrayData(n, n2, bl);
        } else {
            this.readGeneralData(n, n2, bl);
        }
    }

    private void readArrayData(int n, int n2, boolean bl) throws IOException {
        this.baseDS.xvalues = new double[1][n2];
        this.baseDS.yvalues = new double[n][n2];
        this.baseDS.seriesLabels = new String[n];
        this.baseDS.pointLabels = new String[n2];
        if (bl) {
            String string;
            int n3 = 0;
            while (n3 < n + 1) {
                if (this.tokenizer.nextToken() == 39) {
                    if (n3 > 0) {
                        string = new String(this.tokenizer.sval);
                        this.baseDS.seriesLabels[n3 - 1] = ChartDataSourceUtil.processText(string);
                    }
                } else {
                    this.tokenizer.pushBack();
                    break;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n2) {
                if (this.tokenizer.nextToken() == 39) {
                    string = new String(this.tokenizer.sval);
                    this.baseDS.pointLabels[n3] = ChartDataSourceUtil.processText(string);
                } else {
                    this.tokenizer.pushBack();
                }
                this.baseDS.xvalues[0][n3] = this.getNextDouble();
                int n4 = 0;
                while (n4 < n) {
                    this.baseDS.yvalues[n4][n3] = this.getNextDouble();
                    ++n4;
                }
                ++n3;
            }
        } else {
            String string;
            Object var6_7 = null;
            int n5 = 0;
            while (n5 < n2) {
                if (this.tokenizer.nextToken() == 39) {
                    string = new String(this.tokenizer.sval);
                    this.baseDS.pointLabels[n5] = ChartDataSourceUtil.processText(string);
                } else {
                    this.tokenizer.pushBack();
                }
                ++n5;
            }
            int n6 = 0;
            while (n6 < n + 1) {
                if (this.tokenizer.nextToken() == 39) {
                    if (n6 > 0) {
                        string = new String(this.tokenizer.sval);
                        this.baseDS.seriesLabels[n6 - 1] = ChartDataSourceUtil.processText(string);
                    }
                } else {
                    this.tokenizer.pushBack();
                }
                n5 = 0;
                while (n5 < n2) {
                    double d = this.getNextDouble();
                    if (n6 == 0) {
                        this.baseDS.xvalues[0][n5] = d;
                    } else {
                        this.baseDS.yvalues[n6 - 1][n5] = d;
                    }
                    ++n5;
                }
                ++n6;
            }
        }
    }

    private void readGeneralData(int n, int n2, boolean bl) throws IOException {
        int n3;
        this.baseDS.xvalues = new double[n][];
        this.baseDS.yvalues = new double[n][];
        this.baseDS.seriesLabels = new String[n];
        this.baseDS.pointLabels = new String[n2];
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("labels")) {
            n3 = 0;
            while (n3 < n2) {
                if (this.tokenizer.nextToken() != 39) {
                    this.displayErrorMessage(3);
                    throw new IOException("Error in reading point labels - " + this.tokenizer);
                }
                String string = new String(this.tokenizer.sval);
                this.baseDS.pointLabels[n3] = ChartDataSourceUtil.processText(string);
                ++n3;
            }
        } else {
            this.tokenizer.pushBack();
            this.baseDS.pointLabels = null;
        }
        if (bl) {
            int n4 = 0;
            while (n4 < n) {
                if (this.tokenizer.nextToken() == 39) {
                    String string = new String(this.tokenizer.sval);
                    this.baseDS.seriesLabels[n4] = ChartDataSourceUtil.processText(string);
                } else {
                    this.tokenizer.pushBack();
                }
                n2 = (int)this.getNextDouble();
                this.baseDS.xvalues[n4] = new double[n2];
                this.baseDS.yvalues[n4] = new double[n2];
                int n5 = 0;
                while (n5 < n2) {
                    this.baseDS.xvalues[n4][n5] = this.getNextDouble();
                    this.baseDS.yvalues[n4][n5] = this.getNextDouble();
                    ++n5;
                }
                ++n4;
            }
        } else {
            int n6 = 0;
            while (n6 < n) {
                if (this.tokenizer.nextToken() == 39) {
                    String string = new String(this.tokenizer.sval);
                    this.baseDS.seriesLabels[n6] = ChartDataSourceUtil.processText(string);
                } else {
                    this.tokenizer.pushBack();
                }
                n2 = (int)this.getNextDouble();
                this.baseDS.xvalues[n6] = new double[n2];
                this.baseDS.yvalues[n6] = new double[n2];
                n3 = 0;
                while (n3 < 2) {
                    int n7 = 0;
                    while (n7 < n2) {
                        double d = this.getNextDouble();
                        if (n3 == 0) {
                            this.baseDS.xvalues[n6][n7] = d;
                        } else {
                            this.baseDS.yvalues[n6][n7] = d;
                        }
                        ++n7;
                    }
                    ++n3;
                }
                ++n6;
            }
        }
    }
}

