/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.swing.JCSpinBoxEditor;
import com.klg.jclass.util.swing.JCSpinBoxRenderer;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import com.klg.jclass.util.value.ObjectValueModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.metal.MetalLookAndFeel;

public abstract class AbstractSpinBox
extends JComponent {
    protected boolean continuousScroll = false;
    protected JCSpinBoxEditor editor;
    protected JCSpinBoxRenderer renderer;
    protected JPanel renderPanel = new JPanel(new BorderLayout());
    protected JButton downArrow;
    protected JButton upArrow;
    protected boolean arrowKeySpinningAllowed = true;
    protected Listener l = new Listener();
    protected RendererListener rl = new RendererListener();
    private static boolean TRACE = false;
    protected Timer buttonTimer;
    protected JButton currentButton = null;
    protected JCValueModel valueModel;
    protected JCListenerList valueListeners;
    protected boolean editable = true;
    protected static boolean editorIsValidateRoot = true;
    protected static final Border metalBorder = new MetalBorder();
    static final Dimension defaultPreferredSize = new Dimension(1, 1);
    protected static final int NONE = 0;
    protected static final int INCREMENT = 1;
    protected static final int DECREMENT = -1;
    static final int BEGIN = 0;
    static final int END = 1;
    private boolean firstTime = true;

    public AbstractSpinBox(JCValueModel jCValueModel, JCSpinBoxEditor jCSpinBoxEditor, JCSpinBoxRenderer jCSpinBoxRenderer) {
        super.setLayout(null);
        this.setValueModel(jCValueModel);
        this.setEditor(jCSpinBoxEditor);
        this.setRenderer(jCSpinBoxRenderer);
        this.configureArrowButtons();
    }

    public AbstractSpinBox(JCValueModel jCValueModel, JCSpinBoxEditor jCSpinBoxEditor) {
        this(jCValueModel, jCSpinBoxEditor, new DefaultRenderer());
    }

    public AbstractSpinBox() {
        this(new ObjectValueModel(), new DefaultEditor());
    }

    public void setContinuousScroll(boolean bl) {
        this.continuousScroll = bl;
        this.buttonTimer.removeActionListener(this.l);
        if (bl) {
            this.buttonTimer.addActionListener(this.l);
        }
    }

    public boolean isContinuousScroll() {
        return this.continuousScroll;
    }

    public void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
        this.configureArrowButtons();
    }

    public void updateUI() {
        this.setUI(null);
    }

    public void addValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.add(this.valueListeners, jCValueListener);
    }

    public void removeValueListener(JCValueListener jCValueListener) {
        this.valueListeners = JCListenerList.remove(this.valueListeners, jCValueListener);
    }

    public void setValueModel(JCValueModel jCValueModel) {
        JCValueModel jCValueModel2 = this.getValueModel();
        if (jCValueModel2 == jCValueModel) {
            return;
        }
        if (jCValueModel2 != null) {
            jCValueModel2.removeValueListener(this.l);
        }
        this.valueModel = jCValueModel;
        this.firePropertyChange("valueModel", jCValueModel2, jCValueModel);
        this.valueModel.addValueListener(this.l);
    }

    public JCValueModel getValueModel() {
        return this.valueModel;
    }

    public void setValue(Object object) {
        JCValueModel jCValueModel;
        if (!this.compareToValue(object) && (jCValueModel = this.getValueModel()) != null && object != null) {
            jCValueModel.setValue(object);
        }
    }

    public boolean compareToValue(Object object) {
        JCValueModel jCValueModel = this.getValueModel();
        if (jCValueModel == null) {
            return false;
        }
        Object object2 = jCValueModel.getValue();
        if (object2 == null) {
            return object == null;
        }
        return object2.equals(object);
    }

    protected JButton createIncrArrow() {
        String string = UIManager.getLookAndFeel().getID();
        if (string.equals("Metal")) {
            return new MetalArrowButton(0);
        }
        return new ArrowButton(1);
    }

    protected JButton createDecrArrow() {
        String string = UIManager.getLookAndFeel().getID();
        if (string.equals("Metal")) {
            return new MetalArrowButton(1);
        }
        return new ArrowButton(5);
    }

    public void configureArrowButtons() {
        if (this.upArrow != null) {
            this.remove(this.upArrow);
            this.upArrow = null;
        }
        if (this.downArrow != null) {
            this.remove(this.downArrow);
            this.downArrow = null;
        }
        if (this.buttonTimer != null) {
            this.buttonTimer.stop();
        }
        this.buttonTimer = null;
        this.upArrow = this.createIncrArrow();
        this.add(this.upArrow);
        this.downArrow = this.createDecrArrow();
        this.add(this.downArrow);
        this.setEnabled(this.isEnabled());
        this.upArrow.setRequestFocusEnabled(false);
        this.upArrow.setPreferredSize(new Dimension(14, 14));
        this.downArrow.setRequestFocusEnabled(false);
        this.downArrow.setPreferredSize(new Dimension(14, 14));
        this.upArrow.removeMouseListener(this.l);
        this.downArrow.removeMouseListener(this.l);
        this.upArrow.addMouseListener(this.l);
        this.downArrow.addMouseListener(this.l);
        this.buttonTimer = new Timer(200, this.l);
        if (!this.continuousScroll) {
            this.buttonTimer.removeActionListener(this.l);
        }
        this.buttonTimer.setInitialDelay(0);
    }

    public void requestFocus() {
        if (this.editable && this.editor.getEditorComponent() != null && JCEnvironment.getJavaVersion() < 140) {
            this.editor.getEditorComponent().requestFocus();
            return;
        }
        super.requestFocus();
    }

    public void setEditable(boolean bl) {
        boolean bl2 = bl != this.editable;
        this.editable = bl;
        if (bl2) {
            this.swapEditorRenderer();
            this.firePropertyChange("editable", !this.editable, this.editable);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.downArrow != null && this.upArrow != null) {
            this.downArrow.setEnabled(bl);
            this.upArrow.setEnabled(bl);
        }
        if (this.isEditable() && this.editor.getEditorComponent() != null) {
            this.editor.getEditorComponent().setEnabled(bl);
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public boolean isFocusTraversable() {
        return !this.isEditable();
    }

    public void setEditor(JCSpinBoxEditor jCSpinBoxEditor) {
        JCSpinBoxEditor jCSpinBoxEditor2 = jCSpinBoxEditor;
        if (this.editor != null) {
            this.remove(this.editor.getEditorComponent());
            this.editor.getEditorComponent().removeFocusListener(this.l);
        }
        this.editor = jCSpinBoxEditor;
        if (this.isEditable()) {
            Component component = jCSpinBoxEditor.getEditorComponent();
            this.setEnabled(this.isEnabled());
            this.add(component);
            component.addFocusListener(this.l);
            component.addKeyListener(this.l);
        }
        this.firePropertyChange("editor", jCSpinBoxEditor2, jCSpinBoxEditor);
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    public JCSpinBoxEditor getEditor() {
        return this.editor;
    }

    public void setRenderer(JCSpinBoxRenderer jCSpinBoxRenderer) {
        Component component;
        JCSpinBoxRenderer jCSpinBoxRenderer2 = this.renderer;
        if (this.renderer != null) {
            component = this.renderer.getComponent(this, null);
            this.renderPanel.remove(component);
            component.removeMouseListener(this.rl);
        }
        this.renderer = jCSpinBoxRenderer;
        component = this.getValueModel() != null ? this.renderer.getComponent(this, this.getValueModel().getValue()) : this.renderer.getComponent(this, null);
        this.renderPanel.add(component, "Center");
        component.enableInputMethods(true);
        component.addMouseListener(this.rl);
        if (!this.isEditable()) {
            this.remove(this.renderPanel);
            this.add(this.renderPanel);
            this.addFocusListener(this.l);
            this.addKeyListener(this.l);
        }
        this.firePropertyChange("renderer", jCSpinBoxRenderer2, this.renderer);
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    public JCSpinBoxRenderer getRenderer() {
        return this.renderer;
    }

    protected void swapEditorRenderer() {
        Component component = this.editor.getEditorComponent();
        this.remove(component);
        component.removeFocusListener(this.l);
        component.removeKeyListener(this.l);
        this.remove(this.renderPanel);
        this.removeFocusListener(this.l);
        this.removeKeyListener(this.l);
        if (this.isEditable()) {
            this.setRequestFocusEnabled(false);
            this.add(component);
            component.setEnabled(this.isEnabled());
            component.addFocusListener(this.l);
            component.addKeyListener(this.l);
        } else {
            this.setRequestFocusEnabled(true);
            this.add(this.renderPanel);
            this.addFocusListener(this.l);
            this.addKeyListener(this.l);
        }
        this.repaint();
    }

    public JButton getDecrementArrow() {
        return this.downArrow;
    }

    public JButton getIncrementArrow() {
        return this.upArrow;
    }

    public boolean isArrowKeySpinningAllowed() {
        return this.arrowKeySpinningAllowed;
    }

    public void setArrowKeySpinningAllowed(boolean bl) {
        this.arrowKeySpinningAllowed = bl;
    }

    protected int preferredWidthOfView() {
        int n = 0;
        Component component = null;
        component = this.isEditable() ? this.editor.getEditorComponent() : this.renderer.getComponent(this, this.getValueModel().getValue());
        if (component != null) {
            n = component.getPreferredSize().width;
        }
        return n + this.upArrow.getPreferredSize().width;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension == null || dimension.equals(defaultPreferredSize) || this.firstTime) {
            this.doBorder();
            dimension = new Dimension(this.preferredWidthOfView() + this.upArrow.getPreferredSize().width + this.renderPanel.getInsets().left + this.renderPanel.getInsets().right, this.preferredHeightOfView());
            this.setPreferredSize(dimension);
            this.firstTime = false;
        }
        return dimension;
    }

    protected int preferredHeightOfView() {
        int n = 0;
        Component component = null;
        if (this.isEditable()) {
            component = this.editor.getEditorComponent();
        } else {
            component = this.renderer.getComponent(this, this.getValueModel().getValue());
            n = this.renderPanel.getInsets().top + this.renderPanel.getInsets().bottom;
        }
        if (component != null) {
            n += component.getPreferredSize().height;
        }
        return n;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
    }

    public synchronized void doLayout() {
        int n;
        Dimension dimension = this.getSize();
        int n2 = 20;
        if (n2 < dimension.height) {
            n2 = dimension.height;
        }
        int n3 = n = n2 / 2;
        int n4 = this.getSize().width - n3;
        this.editor.getEditorComponent().setBounds(0, 0, this.getSize().width - n3, n * 2);
        Component component = this.getValueModel() == null ? this.renderer.getComponent(this, null) : this.renderer.getComponent(this, this.getValueModel().getValue());
        this.renderPanel.setBounds(0, 0, this.getSize().width - n3, n * 2);
        this.doBorder();
        component.setFont(this.getFont());
        this.upArrow.setBounds(n4, 0, n3, n);
        this.downArrow.setBounds(n4, n, n3, n);
        this.checkArrowButtons();
    }

    protected void doFocusedLook(Graphics graphics) {
        if (this.isEditable()) {
            return;
        }
        Component component = this.getValueModel() == null ? this.renderer.getComponent(this, null) : this.renderer.getComponent(this, this.getValueModel().getValue());
        String string = UIManager.getLookAndFeel().getID();
        component.setForeground(UIManager.getColor("ComboBox.foreground"));
        component.setBackground(UIManager.getColor("ComboBox.background"));
        if (string.equals("Motif")) {
            graphics.setColor(UIManager.getColor("activeCaptionBorder"));
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        } else if (!string.equals("Metal")) {
            component.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
            component.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
        }
    }

    protected void doNonFocusedLook(Graphics graphics) {
        if (this.isEditable()) {
            return;
        }
        Component component = this.getValueModel() == null ? this.renderer.getComponent(this, null) : this.renderer.getComponent(this, this.getValueModel().getValue());
        String string = UIManager.getLookAndFeel().getID();
        component.setBackground(UIManager.getColor("ComboBox.background"));
        component.setForeground(UIManager.getColor("ComboBox.foreground"));
    }

    protected void doBorder() {
        String string = UIManager.getLookAndFeel().getID();
        if (string.equals("Metal")) {
            this.renderPanel.setBorder(metalBorder);
        } else {
            this.renderPanel.setBorder(UIManager.getBorder("ComboBox.border"));
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isEditable()) {
            return;
        }
        if (this.hasFocus()) {
            this.doFocusedLook(graphics);
        } else {
            this.doNonFocusedLook(graphics);
        }
    }

    public void setArrowEnabled(JButton jButton, boolean bl) {
        if (this.isEnabled() && jButton.isEnabled() != bl) {
            jButton.doClick();
            jButton.setEnabled(bl);
        }
    }

    protected abstract void checkArrowButtons();

    protected abstract Object spinUp();

    protected abstract Object spinDown();

    protected void processValueChanging(JCValueEvent jCValueEvent) {
        JCValueEvent jCValueEvent2 = new JCValueEvent(this, jCValueEvent.getOldValue(), jCValueEvent.getNewValue());
        Enumeration enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            JCValueListener jCValueListener = (JCValueListener)enumeration.nextElement();
            jCValueListener.valueChanging(jCValueEvent2);
        }
        jCValueEvent.setAllowChange(jCValueEvent2.getAllowChange());
        jCValueEvent.setNewValue(jCValueEvent2.getNewValue());
    }

    protected void processValueChanged(JCValueEvent jCValueEvent) {
        JCValueEvent jCValueEvent2 = new JCValueEvent(this, jCValueEvent.getOldValue(), jCValueEvent.getNewValue());
        Enumeration enumeration = JCListenerList.elements(this.valueListeners);
        while (enumeration.hasMoreElements()) {
            JCValueListener jCValueListener = (JCValueListener)enumeration.nextElement();
            jCValueListener.valueChanged(jCValueEvent2);
        }
    }

    protected void handleKeyPressed(KeyEvent keyEvent) {
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    protected void processFocusLost(FocusEvent focusEvent) {
        if (this.isEditable()) {
            this.setValue(this.editor.getItem());
            this.checkArrowButtons();
        }
    }

    public static class MetalBorder
    extends AbstractBorder
    implements UIResource,
    Serializable {
        protected static Insets borderInsets = new Insets(4, 4, 4, 4);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component.isEnabled()) {
                graphics.translate(n, n2);
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                graphics.drawRect(0, 0, n3 - 2, n4 - 2);
                graphics.setColor(MetalLookAndFeel.getControlHighlight());
                graphics.drawRect(1, 1, n3 - 2, n4 - 2);
                graphics.setColor(MetalLookAndFeel.getControl());
                graphics.drawLine(0, n4 - 1, 1, n4 - 2);
                graphics.drawLine(n3 - 1, 0, n3 - 2, 1);
                graphics.translate(-n, -n2);
                if (component.getParent().hasFocus()) {
                    graphics.setColor(MetalLookAndFeel.getFocusColor());
                    graphics.drawRect(n + 2, n2 + 2, n3 - 6, n4 - 6);
                }
            } else {
                graphics.translate(n, n2);
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }
    }

    public class ArrowButton
    extends BasicArrowButton
    implements Serializable {
        public ArrowButton(int n) {
            super(n);
        }
    }

    public class MetalArrowButton
    extends JButton {
        public MetalArrowButton(int n) {
            super(new ArrowIcon(n));
        }
    }

    static class DefaultRenderer
    extends JLabel
    implements JCSpinBoxRenderer {
        public DefaultRenderer() {
            this.setOpaque(true);
        }

        public boolean isValidateRoot() {
            return editorIsValidateRoot;
        }

        public Component getComponent(AbstractSpinBox abstractSpinBox, Object object) {
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText(" ");
            }
            return this;
        }
    }

    static class DefaultEditor
    extends JTextField
    implements JCSpinBoxEditor {
        DefaultEditor() {
        }

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object object) {
            if (object == null) {
                this.setText("");
            } else {
                this.setText(object.toString());
            }
        }

        public Object getItem() {
            return this.getText();
        }
    }

    static class ArrowIcon
    implements Icon,
    Serializable {
        public static final int UP = 0;
        public static final int DOWN = 1;
        int direction;

        public ArrowIcon(int n) {
            this.direction = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Dimension dimension = component.getSize();
            int n3 = this.getIconWidth();
            Color color = component.getForeground();
            if (!((JComponent)component).isEnabled()) {
                color = UIManager.getColor("Button.disabledText");
            }
            graphics.setColor(color);
            graphics.translate(n, n2);
            if (this.direction == 1) {
                graphics.drawLine(0, 0, n3 - 2, 0);
                graphics.drawLine(1, 1, 1 + (n3 - 4), 1);
                graphics.drawLine(2, 2, 2 + (n3 - 6), 2);
            } else {
                graphics.drawLine(2, 0, 2 + (n3 - 6), 0);
                graphics.drawLine(1, 1, 1 + (n3 - 4), 1);
                graphics.drawLine(0, 2, n3 - 2, 2);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 6;
        }

        public int getIconHeight() {
            return 4;
        }
    }

    class Listener
    implements KeyListener,
    MouseListener,
    ActionListener,
    JCValueListener,
    FocusListener,
    Serializable {
        Listener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JButton jButton = (JButton)mouseEvent.getSource();
            if (jButton.isEnabled() && jButton.equals(AbstractSpinBox.this.currentButton) && AbstractSpinBox.this.currentButton.getModel().isPressed()) {
                AbstractSpinBox.this.buttonTimer.start();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (((JButton)mouseEvent.getSource()).equals(AbstractSpinBox.this.currentButton) && AbstractSpinBox.this.currentButton.getModel().isPressed()) {
                AbstractSpinBox.this.buttonTimer.stop();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            AbstractSpinBox.this.currentButton = (JButton)mouseEvent.getSource();
            AbstractSpinBox.this.buttonTimer.start();
            if (!AbstractSpinBox.this.continuousScroll) {
                this.actionPerformed(null);
            }
            AbstractSpinBox.this.requestFocus();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AbstractSpinBox.this.currentButton = null;
            if (AbstractSpinBox.this.buttonTimer.isRunning()) {
                AbstractSpinBox.this.buttonTimer.stop();
            }
            AbstractSpinBox.this.repaint();
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object = null;
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 38: {
                    if (AbstractSpinBox.this.editable && !AbstractSpinBox.this.compareToValue(AbstractSpinBox.this.editor.getItem())) {
                        AbstractSpinBox.this.setValue(AbstractSpinBox.this.editor.getItem());
                    }
                    if (!AbstractSpinBox.this.upArrow.isEnabled() || !AbstractSpinBox.this.arrowKeySpinningAllowed) break;
                    object = AbstractSpinBox.this.spinUp();
                    keyEvent.consume();
                    AbstractSpinBox.this.setValue(object);
                    AbstractSpinBox.this.checkArrowButtons();
                    break;
                }
                case 40: {
                    if (AbstractSpinBox.this.editable && !AbstractSpinBox.this.compareToValue(AbstractSpinBox.this.editor.getItem())) {
                        AbstractSpinBox.this.setValue(AbstractSpinBox.this.editor.getItem());
                    }
                    if (!AbstractSpinBox.this.downArrow.isEnabled() || !AbstractSpinBox.this.arrowKeySpinningAllowed) break;
                    object = AbstractSpinBox.this.spinDown();
                    keyEvent.consume();
                    AbstractSpinBox.this.setValue(object);
                    AbstractSpinBox.this.checkArrowButtons();
                    break;
                }
                case 10: 
                case 27: {
                    if (!AbstractSpinBox.this.editable || AbstractSpinBox.this.compareToValue(AbstractSpinBox.this.editor.getItem())) break;
                    AbstractSpinBox.this.setValue(AbstractSpinBox.this.editor.getItem());
                    AbstractSpinBox.this.checkArrowButtons();
                    break;
                }
                default: {
                    AbstractSpinBox.this.handleKeyPressed(keyEvent);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = null;
            if (AbstractSpinBox.this.currentButton == null || !AbstractSpinBox.this.currentButton.isEnabled()) {
                return;
            }
            if (TRACE) {
                System.out.println("Spin.actionPerformed()");
            }
            if (AbstractSpinBox.this.upArrow.equals(AbstractSpinBox.this.currentButton)) {
                if (AbstractSpinBox.this.editable && !AbstractSpinBox.this.compareToValue(AbstractSpinBox.this.editor.getItem())) {
                    AbstractSpinBox.this.setValue(AbstractSpinBox.this.editor.getItem());
                }
                object = AbstractSpinBox.this.spinUp();
            } else if (AbstractSpinBox.this.downArrow.equals(AbstractSpinBox.this.currentButton)) {
                if (AbstractSpinBox.this.editable && !AbstractSpinBox.this.compareToValue(AbstractSpinBox.this.editor.getItem())) {
                    AbstractSpinBox.this.setValue(AbstractSpinBox.this.editor.getItem());
                }
                object = AbstractSpinBox.this.spinDown();
            } else {
                return;
            }
            if (TRACE) {
                System.out.println("\tabout to check arrow buttons");
            }
            AbstractSpinBox.this.setValue(object);
            AbstractSpinBox.this.checkArrowButtons();
            if (TRACE) {
                System.out.println("\tarrow buttons checked");
            }
            AbstractSpinBox.this.buttonTimer.start();
        }

        public void valueChanging(JCValueEvent jCValueEvent) {
            AbstractSpinBox.this.processValueChanging(jCValueEvent);
        }

        public void valueChanged(JCValueEvent jCValueEvent) {
            AbstractSpinBox.this.processValueChanged(jCValueEvent);
        }

        public void focusGained(FocusEvent focusEvent) {
            AbstractSpinBox.this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            AbstractSpinBox.this.processFocusLost(focusEvent);
            AbstractSpinBox.this.repaint();
        }
    }

    class RendererListener
    implements MouseListener,
    Serializable {
        RendererListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            AbstractSpinBox.this.requestFocus();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

