/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import java.awt.Color;
import java.awt.Graphics;

public class JCBorder {
    public static final int NONE = 0;
    public static final int ETCHED_IN = 1;
    public static final int ETCHED_OUT = 2;
    public static final int IN = 3;
    public static final int OUT = 4;
    public static final int PLAIN = 5;
    public static final int FRAME_IN = 6;
    public static final int FRAME_OUT = 7;
    public static final int CONTROL_IN = 8;
    public static final int CONTROL_OUT = 9;
    public static final int NUM_BORDER_STYLES = 10;
    public static final String[] border_strings = new String[]{"None", "Etched_In", "Etched_Out", "In", "Out", "Plain", "Frame_In", "Frame_Out", "Control_In", "Control_Out"};
    public static final int[] border_values = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final Color WHITE_BRIGHTER = new Color(200, 200, 200);
    private static final Color WHITE_DARKER = new Color(140, 140, 140);
    private static final Color BLACK_BRIGHTER = new Color(125, 125, 125);
    private static final Color BLACK_DARKER = new Color(75, 75, 75);
    private static final double FACTOR = 0.5;

    public static void drawTopLines(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        int n6 = 0;
        while (n6 < n) {
            graphics.drawLine(n2 + n6, n3 + n6, n2 + n4 - (n6 + 1), n3 + n6);
            graphics.drawLine(n2 + n6, n3 + n6 + 1, n2 + n6, n3 + n5 - (n6 + 1));
            ++n6;
        }
    }

    public static void drawBottomLines(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color) {
        graphics.setColor(color);
        int n6 = 1;
        while (n6 <= n) {
            graphics.drawLine(n2 + n6 - 1, n3 + n5 - n6, n2 + n4 - n6, n3 + n5 - n6);
            graphics.drawLine(n2 + n4 - n6, n3 + n6 - 1, n2 + n4 - n6, n3 + n5 - n6);
            ++n6;
        }
    }

    public static void drawNormal(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2) {
        JCBorder.drawTopLines(graphics, n, n2, n3, n4, n5, color);
        JCBorder.drawBottomLines(graphics, n, n2, n3, n4, n5, color2);
    }

    public static Color brighter(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_BRIGHTER;
        }
        if (color.equals(Color.black)) {
            return BLACK_BRIGHTER;
        }
        int n = color.getRed();
        n += (int)((double)(255 - n) * 0.5);
        int n2 = color.getBlue();
        n2 += (int)((double)(255 - n2) * 0.5);
        int n3 = color.getGreen();
        n3 += (int)((double)(255 - n3) * 0.5);
        return new Color(Math.min(n, 255), Math.min(n3, 255), Math.min(n2, 255));
    }

    public static Color darker(Color color) {
        if (color.equals(Color.white)) {
            return WHITE_DARKER;
        }
        if (color.equals(Color.black)) {
            return BLACK_DARKER;
        }
        return color.darker();
    }

    public static void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2) {
        JCBorder.draw(graphics, n, n2, n3, n4, n5, n6, JCBorder.brighter(color), JCBorder.darker(color), color2);
    }

    public static void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Color color3) {
        Color color4 = graphics.getColor();
        switch (n) {
            case 5: {
                JCBorder.drawNormal(graphics, n2, n3, n4, n5, n6, color3, color3);
                break;
            }
            case 3: {
                JCBorder.drawNormal(graphics, n2, n3, n4, n5, n6, color2, color);
                break;
            }
            case 4: {
                JCBorder.drawNormal(graphics, n2, n3, n4, n5, n6, color, color2);
                break;
            }
            case 8: {
                if (n2 == 2) {
                    JCBorder.drawNormal(graphics, 1, n3 + 1, n4 + 1, n5 - 2, n6 - 2, Color.black, color);
                    JCBorder.drawNormal(graphics, 1, n3, n4, n5, n6, color2, JCBorder.brighter(color));
                    break;
                }
                JCBorder.drawNormal(graphics, n2, n3, n4, n5, n6, color2, color);
                break;
            }
            case 9: {
                if (n2 == 2) {
                    JCBorder.drawNormal(graphics, 1, n3, n4, n5, n6, JCBorder.brighter(color), color2);
                    JCBorder.drawNormal(graphics, 1, n3 + 1, n4 + 1, n5 - 2, n6 - 2, color, Color.black);
                    break;
                }
                JCBorder.drawNormal(graphics, n2, n3, n4, n5, n6, color, color2);
                break;
            }
            case 1: {
                int n7 = n2 % 2;
                int n8 = n7 == 0 ? n2 / 2 : n2 / 2 + 1;
                int n9 = n2 - n8;
                JCBorder.drawNormal(graphics, n8, n3, n4, n5, n6, color2, color);
                JCBorder.drawNormal(graphics, n9, n3 + n8, n4 + n8, n5 - n2 - n7, n6 - n2 - n7, color, color2);
                break;
            }
            case 2: {
                int n10 = n2 % 2;
                int n11 = n10 == 0 ? n2 / 2 : n2 / 2 + 1;
                int n12 = n2 - n11;
                JCBorder.drawNormal(graphics, n11, n3, n4, n5, n6, color, color2);
                JCBorder.drawNormal(graphics, n12, n3 + n11, n4 + n11, n5 - n2 - n10, n6 - n2 - n10, color2, color);
                break;
            }
            case 7: {
                JCBorder.drawNormal(graphics, n2, n3, n4, n5, n6, color, color2);
                JCBorder.drawNormal(graphics, n2 - 1, n3, n4, n5, n6, color3, color3);
                break;
            }
            case 6: {
                JCBorder.drawNormal(graphics, n2, n3, n4, n5, n6, color2, color);
                JCBorder.drawNormal(graphics, n2 - 1, n3, n4, n5, n6, color3, color3);
                break;
            }
        }
        graphics.setColor(color4);
    }
}

