/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCVersion;
import com.klg.jclass.util.swing.JCElasticLayout;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class JCBox
extends JPanel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int h_instance_count = 0;
    private int v_instance_count = 0;
    protected int orientation;

    public JCBox() {
        this(0);
    }

    public JCBox(int n) {
        this.checkOrientation(n);
        if (n == 0) {
            this.setLayout(new JCElasticLayout(0));
            this.setName("HorizontalBox" + this.h_instance_count++);
        } else if (n == 1) {
            this.setLayout(new JCElasticLayout(1));
            this.setName("VerticalBox" + this.v_instance_count++);
        } else {
            throw new IllegalArgumentException("orientation must be HORIZONTAL or VERTICAL");
        }
    }

    public static JCBox createHorizontalBox() {
        return new JCBox(0);
    }

    public static JCBox createVerticalBox() {
        return new JCBox(1);
    }

    public void setAbout(String string) {
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public void setOrientation(int n) {
        this.checkOrientation(n);
        if (this.orientation == n) {
            return;
        }
        this.orientation = n;
        if (n == 0) {
            super.setLayout(new JCElasticLayout(0));
        } else {
            super.setLayout(new JCElasticLayout(1));
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setAlignment(int n) {
        ((JCElasticLayout)this.getLayout()).setAlignment(n);
        this.invalidate();
    }

    public int getAlignment() {
        return ((JCElasticLayout)this.getLayout()).getAlignment();
    }

    public void checkOrientation(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Orientation must be one of HORIZONTAL or VERTICAL");
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof JCElasticLayout) {
            super.setLayout(layoutManager);
        }
    }
}

