/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ActionHandler;
import com.klg.jclass.chart.AnnoBoundsInfo;
import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.ChartRegion;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.Offsets;
import com.klg.jclass.chart.PlotArea;
import com.klg.jclass.chart.PolarAxisParams;
import com.klg.jclass.chart.PolarChartDraw;
import com.klg.jclass.util.legend.JCLegend;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class JCChartArea
extends ChartRegion {
    public static final int MAX_ELEVATION = 45;
    public static final int MAX_ROTATION = 45;
    public static final int MAX_DEPTH = 500;
    public static final String ERRMSG_INVALID_XAXIS_INDEX = "Invalid X axis index";
    public static final String ERRMSG_INVALID_YAXIS_INDEX = "Invalid Y axis index";
    protected static final int INVALID_INDEX = -1;
    protected Vector xaxes = new Vector();
    protected Vector yaxes = new Vector();
    protected int angleUnit = 2;
    protected JCAxis horizActionAxis;
    protected JCAxis vertActionAxis;
    protected boolean axisBoundingBox = false;
    protected boolean fastAction = false;
    protected boolean inAction = false;
    protected int depth = 0;
    protected int elevation = 0;
    protected int rotation = 0;
    private transient Hashtable drawables = new Hashtable();
    public transient Hashtable axisHashtable;
    private PlotArea plotArea = new PlotArea(this);
    protected Rectangle chartAreaRect = new Rectangle(0, 0, 0, 0);
    public Rectangle plotRect = new Rectangle(0, 0, 0, 0);
    public int deltaX = 0;
    public int deltaY = 0;
    public boolean draw3D = false;
    public boolean hasBar = false;
    protected boolean axisDrawOkay = false;
    public boolean pieFirst = false;
    public boolean polarRadarFirst = false;
    protected PolarAxisParams polarAxisParams = new PolarAxisParams();
    protected Rectangle backplane;
    protected int symbolPad = 0;
    protected transient ActionHandler handler = null;
    protected transient boolean saveDBState = false;
    private transient Graphics prevSetGraphics = null;
    protected Graphics rbGC = null;
    protected Point last = new Point(0, 0);
    protected boolean inSuperReshape = false;

    public JCChartArea() {
        this.setOpaque(false);
        JCChart jCChart = (JCChart)this.getParent();
        JCAxis jCAxis = new JCAxis(this, false, 0);
        jCAxis.setParentChart(jCChart);
        jCAxis.setName(JCChartBundle.string("com.klg.jclass.chart.Key28"));
        JCAxis jCAxis2 = new JCAxis(this, true, 0);
        jCAxis2.setParentChart(jCChart);
        jCAxis2.setName(JCChartBundle.string("com.klg.jclass.chart.Key29"));
        this.xaxes.add(jCAxis);
        this.yaxes.add(jCAxis2);
        this.setHorizActionAxis(jCAxis);
        this.setVertActionAxis(jCAxis2);
    }

    protected void setParentOnAxes(JCChart jCChart) {
        Object object;
        Iterator iterator = this.xaxes.iterator();
        while (iterator.hasNext()) {
            object = (JCAxis)iterator.next();
            ((JCAxis)object).setParentChart(jCChart);
            if (jCChart == null) continue;
            ((JCAxis)object).chartArea = jCChart.getChartArea();
        }
        object = this.yaxes.iterator();
        while (object.hasNext()) {
            JCAxis jCAxis = (JCAxis)object.next();
            jCAxis.setParentChart(jCChart);
            if (jCChart == null) continue;
            jCAxis.chartArea = jCChart.getChartArea();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.setChanged(true, 33);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    public int getAngleUnit() {
        return this.angleUnit;
    }

    public void setAngleUnit(int n) {
        if (!JCChartUtil.validUnit(n)) {
            throw new IllegalArgumentException("Invalid value for AngleUnit.  Must be one of DEGREES, RADIANS or GRADS");
        }
        this.angleUnit = n;
        this.setChanged(true, 2);
    }

    public JCAxis getXAxis(int n) {
        if (this.xaxes == null) {
            return null;
        }
        return (JCAxis)this.xaxes.get(n);
    }

    public void setXAxis(int n, JCAxis jCAxis) {
        if (jCAxis == null) {
            if (n < 0 || n >= this.xaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_XAXIS_INDEX);
            }
            this.removeAxis(n, this.xaxes);
        } else {
            if (n < 0 || n > this.xaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_XAXIS_INDEX);
            }
            if (n < this.xaxes.size()) {
                this.removeAxis(n, this.xaxes);
            }
            jCAxis.setParentChart((JCChart)this.getParent());
            this.addAxis(n, this.xaxes, jCAxis);
        }
        this.setChanged(true, 2);
    }

    public void setXAxes(List list) {
        this.xaxes = new Vector();
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e != null && e instanceof JCAxis) {
                if (e != null) {
                    ((JCAxis)e).setParentChart((JCChart)this.getParent());
                    ((JCAxis)e).vertical = false;
                }
                this.xaxes.add(e);
            }
            ++n;
        }
        this.setChanged(true, 2);
    }

    public List getXAxes() {
        return this.xaxes;
    }

    public JCAxis getYAxis(int n) {
        if (this.yaxes == null) {
            return null;
        }
        return (JCAxis)this.yaxes.get(n);
    }

    public void setYAxis(int n, JCAxis jCAxis) {
        if (jCAxis == null) {
            if (n < 0 || n >= this.yaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_YAXIS_INDEX);
            }
            this.removeAxis(n, this.yaxes);
        } else {
            if (n < 0 || n > this.yaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_YAXIS_INDEX);
            }
            if (n < this.yaxes.size()) {
                this.removeAxis(n, this.yaxes);
            }
            jCAxis.setParentChart((JCChart)this.getParent());
            this.addAxis(n, this.yaxes, jCAxis);
        }
        this.setChanged(true, 2);
    }

    public void setYAxes(List list) {
        this.yaxes = new Vector();
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e != null && e instanceof JCAxis) {
                if (e != null) {
                    ((JCAxis)e).setParentChart((JCChart)this.getParent());
                    ((JCAxis)e).vertical = true;
                }
                this.yaxes.add(e);
            }
            ++n;
        }
        this.setChanged(true, 2);
    }

    public List getYAxes() {
        return this.yaxes;
    }

    private void removeAxis(int n, List list) {
        if (n < list.size()) {
            list.remove(n);
        }
    }

    private void replaceAxis(int n, List list, JCAxis jCAxis) {
        list.set(n, jCAxis);
    }

    private void addAxis(int n, List list, JCAxis jCAxis) {
        jCAxis.setParentChart((JCChart)this.getParent());
        list.add(n, jCAxis);
    }

    public void setHorizActionAxis(JCAxis jCAxis) {
        if (jCAxis != null && (jCAxis.vertical || !this.xaxes.contains(jCAxis) && !this.yaxes.contains(jCAxis))) {
            throw new IllegalArgumentException("Invalid horizontal action axis");
        }
        this.horizActionAxis = jCAxis;
    }

    public JCAxis getHorizActionAxis() {
        return this.horizActionAxis;
    }

    public void setVertActionAxis(JCAxis jCAxis) {
        if (!(jCAxis == null || jCAxis.vertical && (this.xaxes.contains(jCAxis) || this.yaxes.contains(jCAxis)))) {
            throw new IllegalArgumentException("Invalid vertical action axis");
        }
        this.vertActionAxis = jCAxis;
    }

    public JCAxis getVertActionAxis() {
        return this.vertActionAxis;
    }

    public void setAxisBoundingBox(boolean bl) {
        if (bl == this.axisBoundingBox) {
            return;
        }
        this.axisBoundingBox = bl;
        this.setChanged(true, 1);
    }

    public boolean getAxisBoundingBox() {
        return this.axisBoundingBox;
    }

    public boolean getFastAction() {
        return this.fastAction;
    }

    public void setFastAction(boolean bl) {
        if (bl == this.fastAction) {
            return;
        }
        this.fastAction = bl;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int n) {
        int n2 = (int)JCChartUtil.clamp((double)n, 0.0, 500.0);
        if (this.depth == n2) {
            return;
        }
        this.depth = n2;
        this.setChanged(true, 2);
    }

    public int getElevation() {
        return this.elevation;
    }

    public void setElevation(int n) {
        int n2 = (int)JCChartUtil.clamp((double)n, -45.0, 45.0);
        if (n2 == this.elevation) {
            return;
        }
        this.elevation = n2;
        this.setChanged(true, 2);
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int n) {
        int n2 = (int)JCChartUtil.clamp((double)n, -45.0, 45.0);
        if (n2 == this.rotation) {
            return;
        }
        this.rotation = n2;
        this.setChanged(true, 2);
    }

    public boolean getChanged() {
        return super.getChanged() || this.isDirty();
    }

    public void setChanged(boolean bl, int n) {
        ChartDraw chartDraw;
        Object object;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        this.ensureDrawables();
        Enumeration enumeration = this.drawables.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            chartDraw = (ChartDraw)this.drawables.get(object);
            chartDraw.setChanged(true, n, false);
            if (bl) continue;
            chartDraw.dataObject.setChanged(false, 0, false);
        }
        this.changed = bl;
        this.changedFlag = this.changed ? (this.changedFlag |= n) : n;
        if (this.changed) {
            if (!jCChart.isBatched()) {
                object = jCChart.getLegend();
                if (object != null && (n & 0x20) > 0) {
                    ((JCLegend)object).setChanged(true, 2, false);
                    ((JCLegend)object).recalc();
                }
                if (object != null && (n & 0x10) > 0) {
                    ((JCLegend)object).setChanged(true, 1, false);
                }
                if ((n & 2) > 0) {
                    this.recalc();
                    jCChart.repaint();
                } else if ((n & 1) > 0) {
                    jCChart.repaint();
                }
            }
            return;
        }
        int n2 = 0;
        while (n2 < this.xaxes.size()) {
            chartDraw = this.xaxes.get(n2);
            if (chartDraw != null && chartDraw instanceof JCAxis) {
                ((JCAxis)((Object)chartDraw)).setChanged(false, 0, false);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.yaxes.size()) {
            Object e = this.yaxes.get(n3);
            if (e != null && e instanceof JCAxis) {
                ((JCAxis)e).setChanged(false, 0, false);
            }
            ++n3;
        }
    }

    public PlotArea getPlotArea() {
        if (this.plotArea == null) {
            this.plotArea = new PlotArea(this);
        }
        return this.plotArea;
    }

    public void paintComponent(Graphics graphics) {
        Serializable serializable;
        if (this.getParent() == null || graphics == null || !this.isVisible()) {
            return;
        }
        super.paintComponent(graphics);
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.getDrawingArea();
        graphics2.translate(rectangle.x, rectangle.y);
        Rectangle rectangle2 = graphics2.getClipBounds();
        Graphics graphics3 = graphics2;
        Rectangle rectangle3 = new Rectangle(0, 0, this.chartAreaRect.width, this.chartAreaRect.height);
        JCChart jCChart = (JCChart)this.getParent();
        try {
            serializable = this.clipForDrawing();
            graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
            this.drawBackplane(graphics3);
            graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            Rectangle rectangle4 = this.clipToEntirePlotRect();
            if (this.pieFirst) {
                this.ensureDrawables();
                Iterator iterator = jCChart.getOriginalDataView().iterator();
                while (iterator.hasNext()) {
                    ChartDataView chartDataView = (ChartDataView)iterator.next();
                    ChartDraw chartDraw = this.getDrawable(chartDataView);
                    if (chartDraw == null || chartDataView.getChartType() != 11) continue;
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    chartDraw.draw(graphics3);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            } else if (this.draw3D) {
                Changeable changeable;
                Object object;
                Object object2;
                Object object3;
                this.ensureDrawables();
                JCAxis jCAxis = null;
                JCAxis jCAxis2 = null;
                Iterator iterator = jCChart.getOriginalDataView().iterator();
                while (iterator.hasNext()) {
                    object3 = (ChartDataView)iterator.next();
                    if (!this.is3DChartType(((ChartDataView)object3).getChartType())) continue;
                    jCAxis = ((ChartDataView)object3).getXAxis();
                    jCAxis2 = ((ChartDataView)object3).getYAxis();
                    break;
                }
                if (this.axisDrawOkay) {
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    this.preDraw3DAxes(graphics3, jCAxis, jCAxis2);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    if (this.axisBoundingBox) {
                        graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                        graphics3.setColor(this.plotArea.getForeground());
                        graphics3.drawRect(this.backplane.x, this.backplane.y, this.backplane.width, this.backplane.height);
                        graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                    graphics3.clipRect(this.backplane.x + 1, this.backplane.y + 1, this.backplane.width - 1, this.backplane.height - 1);
                    if (!this.fastAction || !this.inAction) {
                        this.preDrawGrids(graphics3, this.xaxes);
                        this.preDrawGrids(graphics3, this.yaxes);
                    }
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    if (jCAxis != null && jCAxis.visible) {
                        jCAxis.preDrawOutlineTrough(graphics3);
                    }
                    if (jCAxis2 != null && jCAxis2.visible) {
                        jCAxis2.preDrawOutlineTrough(graphics3);
                    }
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                if (this.axisDrawOkay) {
                    graphics3.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    this.drawBpAxes(graphics3, this.xaxes);
                    this.drawBpAxes(graphics3, this.yaxes);
                    if (!this.fastAction || !this.inAction) {
                        this.drawBpAxisAnnotationsAndTitle(graphics3, this.xaxes);
                        this.drawBpAxisAnnotationsAndTitle(graphics3, this.yaxes);
                    }
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                object3 = jCChart.getOriginalDataView().iterator();
                while (object3.hasNext()) {
                    object2 = (ChartDataView)object3.next();
                    object = this.getDrawable((ChartDataView)object2);
                    if (object == null || ((ChartDataView)object2).getChartType() == 11 || ((ChartDraw)object).drawFront || ((ChartDataView)object2).is3DChartType()) continue;
                    if (((ChartDataView)object2).getChartType() == 0 || ((ChartDataView)object2).getChartType() == 1) {
                        graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                        object.draw(graphics3);
                        graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        continue;
                    }
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    object.draw(graphics3);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                object2 = jCChart.getOriginalDataView().iterator();
                while (object2.hasNext()) {
                    object = (ChartDataView)object2.next();
                    changeable = this.getDrawable((ChartDataView)object);
                    if (changeable == null || ((ChartDataView)object).getChartType() == 11 || !((ChartDataView)object).is3DChartType()) continue;
                    if (((ChartDataView)object).getChartType() == 0 || ((ChartDataView)object).getChartType() == 1) {
                        graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                        changeable.draw(graphics3);
                        graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        continue;
                    }
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    changeable.draw(graphics3);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                if (this.axisDrawOkay) {
                    graphics3.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    this.drawFpAxes(graphics3, this.xaxes);
                    this.drawFpAxes(graphics3, this.yaxes);
                    if (!this.fastAction || !this.inAction) {
                        this.drawFpAxisAnnotationsAndTitle(graphics3, this.xaxes);
                        this.drawFpAxisAnnotationsAndTitle(graphics3, this.yaxes);
                    }
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                object = jCChart.getOriginalDataView().iterator();
                while (object.hasNext()) {
                    changeable = (ChartDataView)object.next();
                    ChartDraw chartDraw = this.getDrawable((ChartDataView)changeable);
                    if (chartDraw == null || ((ChartDataView)changeable).getChartType() == 11 || ((ChartDataView)changeable).is3DChartType() || !chartDraw.drawFront) continue;
                    if (((ChartDataView)changeable).getChartType() == 0 || ((ChartDataView)changeable).getChartType() == 1) {
                        graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                        chartDraw.draw(graphics3);
                        graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        continue;
                    }
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    chartDraw.draw(graphics3);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            } else {
                Changeable changeable;
                Object object;
                if (!(!this.axisDrawOkay || this.fastAction && this.inAction)) {
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    this.preDrawGrids(graphics3, this.xaxes);
                    this.preDrawGrids(graphics3, this.yaxes);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                this.ensureDrawables();
                graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                int n = 0;
                Iterator iterator = jCChart.getOriginalDataView().iterator();
                while (iterator.hasNext()) {
                    object = (ChartDataView)iterator.next();
                    changeable = (ChartDraw)this.drawables.get(object);
                    if (this.polarRadarFirst && n > 0 && !(changeable instanceof PolarChartDraw)) continue;
                    ++n;
                    if (changeable == null || ((ChartDataView)object).getChartType() == 11 || ((ChartDataView)object).getChartType() == 0 || ((ChartDataView)object).getChartType() == 1) continue;
                    changeable.draw(graphics3);
                }
                graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                if (this.axisDrawOkay) {
                    graphics3.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    this.drawAxes(graphics3, this.xaxes);
                    this.drawAxes(graphics3, this.yaxes);
                    if (!this.fastAction || !this.inAction) {
                        this.drawAxisAnnotationsAndTitle(graphics3, this.xaxes);
                        this.drawAxisAnnotationsAndTitle(graphics3, this.yaxes);
                    }
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                n = 0;
                object = jCChart.getOriginalDataView().iterator();
                while (object.hasNext()) {
                    changeable = (ChartDataView)object.next();
                    ChartDraw chartDraw = (ChartDraw)this.drawables.get(changeable);
                    if (this.polarRadarFirst && n > 0 && !(chartDraw instanceof PolarChartDraw)) continue;
                    ++n;
                    if (chartDraw == null || ((ChartDataView)changeable).getChartType() == 11 || ((ChartDataView)changeable).getChartType() != 0 && ((ChartDataView)changeable).getChartType() != 1) continue;
                    chartDraw.draw(graphics3);
                }
                graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
        this.rbGC = graphics;
        if (this.handler != null) {
            this.handler.reanimate(this.last.x, this.last.y);
        }
        this.rbGC = null;
        serializable = (JCChart)this.getParent();
        if (((JCChart)serializable).hasChartLabelManager()) {
            ((JCChart)serializable).getChartLabelManager().recalcChangedChartLabels();
        }
        this.setChanged(false, 0);
    }

    void showAction(int n, int n2) {
        if (this.last.x == n && this.last.y == n2) {
            return;
        }
        this.last.x = n;
        this.last.y = n2;
        this.handler.animate(n, n2);
    }

    void endAction(int n, int n2) {
        if (this.handler == null) {
            return;
        }
        ActionHandler actionHandler = this.handler;
        this.handler = null;
        actionHandler.end(n, n2);
    }

    void startAction(EventTrigger eventTrigger, int n, int n2) {
        this.handler = ActionHandler.makeHandler(eventTrigger.getAction(), this);
        if (this.handler != null) {
            this.handler.start(n, n2);
        }
    }

    public Dimension getPreferredSize() {
        JCChart jCChart = (JCChart)this.getParent();
        this.ensureDrawables();
        Dimension dimension = super.getPreferredSize();
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        if (dimension.width <= 0 || dimension.height <= 0) {
            dimension.width = 100;
            dimension.height = 100;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void recalc() {
        JCChart jCChart;
        if (this.getParent() == null) {
            return;
        }
        if (!this.isChanged() && this.isValid() && !this.isPolarRadar()) {
            return;
        }
        this.ensureDrawables();
        if (this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        try {
            this.resetPlotArea();
            this.calc3D();
            this.calcLimits();
            this.calcAxisParams(this.xaxes);
            this.calcAxisParams(this.yaxes);
            if (!this.inAction || !this.fastAction) {
                this.calcAnchors(this.xaxes);
                this.calcAnchors(this.yaxes);
                this.makeAnnotations(this.xaxes);
                this.makeAnnotations(this.yaxes);
                this.layoutAnnotations(this.xaxes);
                this.layoutAnnotations(this.yaxes);
                this.calcAnnotationExtents(this.xaxes);
                this.calcAnnotationExtents(this.yaxes);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        this.layoutChartArea();
        if (this.checkDeltaValues()) {
            this.layoutChartArea();
        }
        this.calcGraphExtents();
        if (!(this.inAction && this.fastAction || !(jCChart = (JCChart)this.getParent()).hasChartLabelManager())) {
            jCChart.getChartLabelManager().markAllChartLabelsForRecalc();
        }
        this.setChanged(false, 0);
    }

    public void layoutChartArea() {
        this.resetPlotArea();
        this.symbolPad = (this.getBiggestSymbolSize() + 1) / 2;
        int n = this.chartAreaRect.width - this.plotArea.left.value - this.plotArea.right.value;
        int n2 = this.chartAreaRect.height - this.plotArea.top.value - this.plotArea.bottom.value;
        this.plotRect = new Rectangle(this.plotArea.left.value, this.plotArea.top.value, n, n2);
        boolean bl = this.isPolarRadar();
        if (!this.pieFirst) {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            this.getHorizVertAxes(vector2, vector);
            if (!bl) {
                this.adjustPlotRectForAxes(this.xaxes);
                this.adjustPlotRectForAxes(this.yaxes);
            }
            this.layoutAxes(this.xaxes, false);
            this.layoutAxes(this.yaxes, false);
            if (!bl) {
                this.adjustForExtents(vector2, vector);
                this.adjustForSymbols(vector2, vector);
                this.layoutAxes(this.xaxes, true);
                this.layoutAxes(this.yaxes, true);
                this.layoutOrigins(this.xaxes);
                this.layoutOrigins(this.yaxes);
            }
            if (bl) {
                ChartDataView chartDataView;
                JCChart jCChart = (JCChart)this.getParent();
                if (jCChart != null && (chartDataView = (ChartDataView)jCChart.getOriginalDataView().get(0)) != null) {
                    Offsets offsets = new Offsets();
                    this.getPolarChartOffsets(chartDataView, offsets);
                    this.adjustForPolarAnnoExtents(chartDataView.getYAxis(), offsets);
                }
            } else {
                this.adjustForOrthoExtents(vector2, vector);
            }
            if (!this.inAction || !this.fastAction) {
                this.layoutAnnotations(this.xaxes);
                this.layoutAnnotations(this.yaxes);
                this.checkAnnotations(this.xaxes);
                this.checkAnnotations(this.yaxes);
            }
        }
        if (this.plotArea.top.isDefault) {
            this.plotArea.top.value = this.plotRect.y;
        }
        if (this.plotArea.left.isDefault) {
            this.plotArea.left.value = this.plotRect.x;
        }
        if (this.plotArea.bottom.isDefault) {
            this.plotArea.bottom.value = this.chartAreaRect.height - this.plotRect.y - this.plotRect.height;
        }
        if (this.plotArea.right.isDefault) {
            this.plotArea.right.value = this.chartAreaRect.width - this.plotRect.x - this.plotRect.width;
        }
    }

    protected void adjustForPolarAnnoExtents(JCAxis jCAxis, Offsets offsets) {
        jCAxis.adjustCenterAndRadius(offsets.xOffset, offsets.yOffset, offsets.widthOffset);
    }

    protected boolean isPolarRadar() {
        ChartDataView chartDataView;
        boolean bl = false;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null && (chartDataView = (ChartDataView)jCChart.getOriginalDataView().get(0)) != null) {
            bl = chartDataView.chartType == 2 || chartDataView.chartType == 3 || chartDataView.chartType == 4;
        }
        return bl;
    }

    private int getIndexOfMatchingValue(double[] dArray, double d, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        n3 = n;
        while (n3 <= n2) {
            if (dArray[n3] == d) {
                bl = true;
                break;
            }
            ++n3;
        }
        return bl ? n3 : -1;
    }

    private double getRadarLabelAngle(double[] dArray, JCValueLabel jCValueLabel, boolean bl, int n, int n2) {
        int n3 = this.getIndexOfMatchingValue(dArray, jCValueLabel.value, n, n2);
        if (n3 == -1) {
            return 0.0;
        }
        int n4 = n2 - n + 1;
        return JCChartUtil.getRadarAngle(2, n4, n3 - n, bl);
    }

    private boolean isPolarChartCenteredAndWithinView(AnnoBoundsInfo annoBoundsInfo, PolarAxisParams polarAxisParams, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = annoBoundsInfo.x;
        if (bl && (n4 = (int)Math.round(polarAxisParams.xCenter - polarAxisParams.radius)) < n5) {
            n5 = n4;
        }
        n4 = annoBoundsInfo.x + annoBoundsInfo.width;
        if (bl && (n3 = (int)Math.round(polarAxisParams.xCenter + polarAxisParams.radius)) > n4) {
            n4 = n3;
        }
        n3 = annoBoundsInfo.y;
        if (bl && (n2 = (int)Math.round(polarAxisParams.yCenter - polarAxisParams.radius)) < n3) {
            n3 = n2;
        }
        n2 = annoBoundsInfo.y + annoBoundsInfo.height;
        if (bl && (n = (int)Math.round(polarAxisParams.yCenter + polarAxisParams.radius)) > n2) {
            n2 = n;
        }
        n = n5 >= this.plotRect.x && n3 >= this.plotRect.y && n4 <= this.plotRect.x + this.plotRect.width && n2 <= this.plotRect.y + this.plotRect.height ? 1 : 0;
        boolean bl2 = false;
        if (n != 0) {
            int n6 = n5 - this.plotRect.x;
            int n7 = this.plotRect.x + this.plotRect.width - n4;
            int n8 = 0;
            n8 = n6 >= n7 ? (int)((double)n6 * 0.2 + 0.5) : (int)((double)n7 * 0.2 + 0.5);
            if (Math.abs(n6 - n7) <= n8) {
                bl2 = true;
            }
        }
        return n != 0 && bl2;
    }

    protected void getPolarChartOffsets(ChartDataView chartDataView, Offsets offsets) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        JCAxis jCAxis = chartDataView.getXAxis();
        JCAxis jCAxis2 = chartDataView.getYAxis();
        AnnoBoundsInfo annoBoundsInfo = jCAxis.getPolarAnnotationBounds();
        if (annoBoundsInfo == null || !jCAxis.visible || this.isPolarChartCenteredAndWithinView(annoBoundsInfo, jCAxis2.polarAxisParams, !this.isWebShaped(jCAxis2))) {
            offsets.xOffset = 0;
            offsets.yOffset = 0;
            offsets.widthOffset = 0;
            offsets.heightOffset = 0;
            return;
        }
        if (jCAxis2.polarAxisParams.radius <= 1.0 && annoBoundsInfo.x > 0) {
            int n = (annoBoundsInfo.width - this.plotRect.width) / 2;
            int n2 = (annoBoundsInfo.height - this.plotRect.height) / 2;
            offsets.xOffset = -annoBoundsInfo.x - n;
            offsets.yOffset = -annoBoundsInfo.y - n2;
            offsets.widthOffset = 0;
            offsets.heightOffset = 0;
            return;
        }
        boolean bl = chartDataView.chartType == 3 || chartDataView.chartType == 4;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double[] dArray = null;
        if (bl && jCAxis.getAnnotationMethod() != 0) {
            List list = chartDataView.getSeries();
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(0);
            dArray = chartDataViewSeries.getX();
            int[] nArray = ChartDataView.getFirstLastPoints(chartDataView);
            int n = nArray[0];
            int n3 = nArray[1];
            d6 = this.getRadarLabelAngle(dArray, annoBoundsInfo.valueLabelMaxBoundsX, jCAxis.isReversed(), n, n3);
            d8 = this.getRadarLabelAngle(dArray, annoBoundsInfo.valueLabelMaxBoundsY, jCAxis.isReversed(), n, n3);
            d7 = this.getRadarLabelAngle(dArray, annoBoundsInfo.valueLabelMinBoundsX, jCAxis.isReversed(), n, n3);
            d9 = this.getRadarLabelAngle(dArray, annoBoundsInfo.valueLabelMinBoundsY, jCAxis.isReversed(), n, n3);
        } else {
            d6 = JCChartUtil.convertAngle(this.getAngleUnit(), 2, annoBoundsInfo.valueLabelMaxBoundsX.value);
            d8 = JCChartUtil.convertAngle(this.getAngleUnit(), 2, annoBoundsInfo.valueLabelMaxBoundsY.value);
            d7 = JCChartUtil.convertAngle(this.getAngleUnit(), 2, annoBoundsInfo.valueLabelMinBoundsX.value);
            d9 = JCChartUtil.convertAngle(this.getAngleUnit(), 2, annoBoundsInfo.valueLabelMinBoundsY.value);
        }
        d10 = d6 + jCAxis2.polarAxisParams.originBase;
        d12 = d8 + jCAxis2.polarAxisParams.originBase;
        d11 = d7 + jCAxis2.polarAxisParams.originBase;
        d13 = d9 + jCAxis2.polarAxisParams.originBase;
        double d14 = JCChartUtil.getAngleRatio(2, d6, jCAxis.polarAxisParams.originBase, jCAxis.isReversed());
        double d15 = JCChartUtil.getAngleRatio(2, d7, jCAxis.polarAxisParams.originBase, jCAxis.isReversed());
        double d16 = JCChartUtil.getAngleRatio(2, d8, jCAxis.polarAxisParams.originBase, jCAxis.isReversed());
        double d17 = JCChartUtil.getAngleRatio(2, d9, jCAxis.polarAxisParams.originBase, jCAxis.isReversed());
        double d18 = annoBoundsInfo.valueLabelMaxBoundsX.label.left.value + annoBoundsInfo.valueLabelMaxBoundsX.label.width.value;
        double d19 = annoBoundsInfo.valueLabelMinBoundsX.label.left.value;
        double d20 = annoBoundsInfo.valueLabelMaxBoundsY.label.top.value + annoBoundsInfo.valueLabelMaxBoundsY.label.height.value;
        double d21 = annoBoundsInfo.valueLabelMinBoundsY.label.top.value;
        if (!this.isWebShaped(jCAxis2)) {
            d18 = Math.max(d18, jCAxis2.polarAxisParams.xCenter + jCAxis2.polarAxisParams.radius);
            d19 = Math.min(d19, jCAxis2.polarAxisParams.xCenter - jCAxis2.polarAxisParams.radius);
            d20 = Math.max(d20, jCAxis2.polarAxisParams.yCenter + jCAxis2.polarAxisParams.radius);
            d21 = Math.min(d21, jCAxis2.polarAxisParams.yCenter - jCAxis2.polarAxisParams.radius);
        }
        double d22 = d18 - d19 - (double)this.plotRect.width;
        double d23 = d20 - d21 - (double)this.plotRect.height;
        double d24 = 1.0;
        double d25 = 1.0;
        double d26 = 0.0;
        double d27 = 0.0;
        if (this.isWebShaped(jCAxis2) || d18 > jCAxis2.polarAxisParams.xCenter + jCAxis2.polarAxisParams.radius) {
            if (d14 < 0.25) {
                d27 = d10;
                d26 = Math.cos(d27) * jCAxis2.polarAxisParams.radius;
            } else if (d14 > 0.75) {
                d27 = Math.PI * 2 - d10;
                d26 = Math.cos(d27) * jCAxis2.polarAxisParams.radius;
            }
        } else {
            d26 = jCAxis2.polarAxisParams.radius;
        }
        double d28 = 0.0;
        double d29 = 0.0;
        if (this.isWebShaped(jCAxis2) || d19 < jCAxis2.polarAxisParams.xCenter - jCAxis2.polarAxisParams.radius) {
            if (d15 < 0.5 && d15 > 0.25) {
                d29 = Math.PI - d11;
                d28 = Math.cos(d29) * jCAxis2.polarAxisParams.radius;
            } else if (d15 >= 0.5 && d15 < 0.75) {
                d29 = d11 - Math.PI;
                d28 = Math.cos(d29) * jCAxis2.polarAxisParams.radius;
            }
        } else {
            d28 = jCAxis2.polarAxisParams.radius;
        }
        double d30 = d28 + d26;
        double d31 = 0.0;
        if (d26 > d28) {
            d5 = d26 / d30;
            d4 = Math.cos(d27);
            d31 = d22 * d5;
            if (d4 != 0.0) {
                d31 /= d4;
            }
        } else if (d28 > d26) {
            d5 = d28 / d30;
            d4 = Math.cos(d29);
            d31 = d22 * d5;
            if (d4 != 0.0) {
                d31 /= d4;
            }
        } else {
            d31 = d27 != 1.5707963267948966 && d27 != 4.71238898038469 ? d22 * 0.5 / Math.cos(d27) : jCAxis2.polarAxisParams.radius * 0.1;
        }
        d24 = jCAxis2.polarAxisParams.radius - d31;
        d5 = 0.0;
        d4 = 0.0;
        if (this.isWebShaped(jCAxis2) || d20 > jCAxis2.polarAxisParams.yCenter + jCAxis2.polarAxisParams.radius) {
            if (d16 > 0.75) {
                d4 = Math.PI * 2 - d12;
                d5 = Math.sin(d4) * jCAxis2.polarAxisParams.radius;
            } else if (d16 < 0.75 && d16 >= Math.PI) {
                d4 = d12 - Math.PI;
                d5 = Math.sin(d4) * jCAxis2.polarAxisParams.radius;
            } else {
                d5 = jCAxis2.polarAxisParams.radius;
            }
        } else {
            d5 = jCAxis2.polarAxisParams.radius;
        }
        double d32 = 0.0;
        double d33 = 0.0;
        if (this.isWebShaped(jCAxis2) || d21 < jCAxis2.polarAxisParams.yCenter - jCAxis2.polarAxisParams.radius) {
            if (d17 < 0.25) {
                d33 = d13;
                d32 = Math.sin(d33) * jCAxis2.polarAxisParams.radius;
            } else if (d17 <= 0.5 && d17 > 0.25) {
                d33 = Math.PI - d13;
                d32 = Math.sin(d33) * jCAxis2.polarAxisParams.radius;
            } else {
                d32 = jCAxis2.polarAxisParams.radius;
            }
        } else {
            d32 = jCAxis2.polarAxisParams.radius;
        }
        d30 = d32 + d5;
        if (d5 > d32) {
            d3 = d5 / d30;
            d2 = Math.sin(d4);
            d31 = d23 * d3;
            if (d2 != 0.0) {
                d31 /= d2;
            }
        } else if (d32 > d5) {
            d3 = d32 / d30;
            d2 = Math.sin(d33);
            d31 = d23 * d3;
            if (d2 != 0.0) {
                d31 /= d2;
            }
        } else {
            d31 = d4 != 0.0 && d4 != Math.PI ? d23 * 0.5 / Math.sin(d4) : (double)annoBoundsInfo.valueLabelMaxBoundsY.label.height.value;
        }
        d25 = jCAxis2.polarAxisParams.radius - d31;
        d3 = Math.min(d24, d25);
        if (!this.isWebShaped(jCAxis2)) {
            d3 = Math.min(d3, jCAxis2.polarAxisParams.radius * 0.95);
        }
        d3 = Math.max(d3, 1.0);
        Point point = null;
        Point point2 = null;
        Point point3 = null;
        Point point4 = null;
        if (bl) {
            boolean bl2 = jCAxis.isReversed();
            double d34 = bl2 ? -d7 : d7;
            double d35 = bl2 ? -d9 : d9;
            double d36 = bl2 ? -d6 : d6;
            double d37 = bl2 ? -d8 : d8;
            point3 = jCAxis2.toPixelPolar(d34, (int)d3 + jCAxis.getThetaAxisLabelOffset(), false);
            point4 = jCAxis2.toPixelPolar(d35, (int)d3 + jCAxis.getThetaAxisLabelOffset(), false);
            point = jCAxis2.toPixelPolar(d36, (int)d3 + jCAxis.getThetaAxisLabelOffset(), false);
            point2 = jCAxis2.toPixelPolar(d37, (int)d3 + jCAxis.getThetaAxisLabelOffset(), false);
        } else {
            point3 = jCAxis2.toPixelPolar(d7, (int)d3 + jCAxis.getThetaAxisLabelOffset(), false);
            point4 = jCAxis2.toPixelPolar(d9, (int)d3 + jCAxis.getThetaAxisLabelOffset(), false);
            point = jCAxis2.toPixelPolar(d6, (int)d3 + jCAxis.getThetaAxisLabelOffset(), false);
            point2 = jCAxis2.toPixelPolar(d8, (int)d3 + jCAxis.getThetaAxisLabelOffset(), false);
        }
        double d38 = Double.MIN_VALUE;
        double d39 = Double.MAX_VALUE;
        double d40 = Double.MIN_VALUE;
        double d41 = Double.MAX_VALUE;
        double d42 = 0.0;
        double d43 = 0.0;
        double d44 = 0.0;
        double d45 = 0.0;
        if (this.isWebShaped(jCAxis2) || d18 > jCAxis2.polarAxisParams.xCenter + jCAxis2.polarAxisParams.radius) {
            d38 = d14 < 0.25 || d14 > 0.75 ? (double)(point.x + annoBoundsInfo.valueLabelMaxBoundsX.label.width.value) : (double)(point.x + annoBoundsInfo.valueLabelMaxBoundsX.label.width.value / 2);
        }
        if (this.isWebShaped(jCAxis2)) {
            d42 = 0.0;
        } else {
            d42 = jCAxis2.polarAxisParams.xCenter + d3;
            d38 = Math.max(d38, d42);
        }
        if (this.isWebShaped(jCAxis2) || d19 < jCAxis2.polarAxisParams.xCenter - jCAxis2.polarAxisParams.radius) {
            d39 = d15 > 0.25 && d15 < 0.75 ? (double)(point3.x - annoBoundsInfo.valueLabelMinBoundsX.label.width.value) : (double)(point3.x - annoBoundsInfo.valueLabelMinBoundsX.label.width.value / 2);
        }
        if (this.isWebShaped(jCAxis2)) {
            d43 = Double.MAX_VALUE;
        } else {
            d43 = jCAxis2.polarAxisParams.xCenter - d3;
            d39 = Math.min(d39, d43);
        }
        double d46 = d38 - d39;
        double d47 = ((double)this.plotRect.width - d46) / 2.0;
        if (d16 != 0.0 && d16 != 0.5) {
            if (this.isWebShaped(jCAxis2) || d20 > jCAxis2.polarAxisParams.yCenter + jCAxis2.polarAxisParams.radius) {
                d40 = point2.y + annoBoundsInfo.valueLabelMaxBoundsY.label.height.value;
            }
        } else {
            d40 = point2.y + annoBoundsInfo.valueLabelMaxBoundsY.label.height.value / 2;
        }
        if (this.isWebShaped(jCAxis2)) {
            d44 = 0.0;
        } else {
            d44 = jCAxis2.polarAxisParams.yCenter + d3;
            d40 = Math.max(d40, d44);
        }
        if (d17 != 0.0 && d17 != 0.5) {
            if (this.isWebShaped(jCAxis2) || d21 < jCAxis2.polarAxisParams.yCenter - jCAxis2.polarAxisParams.radius) {
                d41 = point4.y - annoBoundsInfo.valueLabelMinBoundsY.label.height.value;
            }
        } else {
            d41 = point4.y - annoBoundsInfo.valueLabelMinBoundsY.label.height.value / 2;
        }
        if (this.isWebShaped(jCAxis2)) {
            d45 = Double.MAX_VALUE;
        } else {
            d45 = jCAxis2.polarAxisParams.yCenter - d3;
            d41 = Math.min(d41, d45);
        }
        double d48 = d40 - d41;
        double d49 = ((double)this.plotRect.height - d48) / 2.0;
        double d50 = 0.0;
        if (d39 < d43) {
            d = jCAxis2.polarAxisParams.xCenter - (double)point3.x;
            d50 = d15 != 0.25 && d15 != 0.75 ? (double)annoBoundsInfo.valueLabelMinBoundsX.label.width.value + d + d47 : (double)(annoBoundsInfo.valueLabelMinBoundsX.label.width.value / 2) + d47;
        } else if (d38 > d42) {
            d = (double)point.x - jCAxis2.polarAxisParams.xCenter;
            d50 = d14 != 0.25 && d14 != 0.75 ? (double)this.plotRect.width - ((double)annoBoundsInfo.valueLabelMaxBoundsX.label.width.value + d + d47) : (double)(annoBoundsInfo.valueLabelMaxBoundsX.label.width.value / 2) + d47;
        } else {
            d50 = (double)this.plotRect.width / 2.0;
        }
        d = 0.0;
        if (d41 < d45) {
            double d51 = jCAxis2.polarAxisParams.yCenter - (double)point4.y;
            d = d17 != 0.0 && d17 != 0.5 ? (double)annoBoundsInfo.valueLabelMinBoundsY.label.height.value + d51 + d49 : (double)(annoBoundsInfo.valueLabelMinBoundsY.label.height.value / 2) + d49;
        } else if (d40 > d44) {
            double d52 = (double)point2.y - jCAxis2.polarAxisParams.yCenter;
            d = d16 != 0.0 && d16 != 0.5 ? (double)this.plotRect.height - ((double)annoBoundsInfo.valueLabelMaxBoundsY.label.height.value + d52 + d49) : (double)(annoBoundsInfo.valueLabelMaxBoundsY.label.height.value / 2) + d49;
        } else {
            d = (double)this.plotRect.height / 2.0;
        }
        offsets.xOffset = (int)(d50 - jCAxis2.polarAxisParams.xCenter);
        offsets.yOffset = (int)(d - jCAxis2.polarAxisParams.yCenter);
        offsets.heightOffset = offsets.widthOffset = (int)(d3 - jCAxis2.polarAxisParams.radius);
    }

    protected boolean isWebShaped(JCAxis jCAxis) {
        return jCAxis.isRadar() && !jCAxis.polarAxisParams.isCircularGrid();
    }

    protected int getBiggestSymbolSize() {
        int n = 0;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null) {
            List list = jCChart.getDataView();
            int n2 = 0;
            while (n2 < list.size()) {
                ChartDataView chartDataView = (ChartDataView)list.get(n2);
                List list2 = chartDataView.getSeries();
                int n3 = 0;
                while (n3 < list2.size()) {
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list2.get(n3);
                    JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
                    n = Math.max(n, jCChartStyle.getSymbolSize());
                    ++n3;
                }
                ++n2;
            }
        }
        return n;
    }

    public boolean isDirty() {
        this.ensureDrawables();
        Enumeration enumeration = this.drawables.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ChartDraw chartDraw = (ChartDraw)this.drawables.get(k);
            if (!chartDraw.dataObject.isChanged()) continue;
            return true;
        }
        int n = 0;
        while (n < this.xaxes.size()) {
            if (((JCAxis)this.xaxes.get(n)).isChanged()) {
                return true;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.yaxes.size()) {
            if (((JCAxis)this.yaxes.get(n2)).isChanged()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n == this.getLocation().x && n2 == this.getLocation().y && n3 == this.getSize().width && n4 == this.getSize().height) {
            return;
        }
        this.inSuperReshape = true;
        super.setBounds(n, n2, n3, n4);
        this.inSuperReshape = false;
        this.changed = true;
        this.changedFlag |= 2;
        this.recalc();
    }

    public void repaint() {
        if (this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        if (this.inSuperReshape) {
            return;
        }
        super.repaint();
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public void setDeltaX(int n) {
        this.deltaX = n;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public void setDeltaY(int n) {
        this.deltaY = n;
    }

    public boolean getDraw3D() {
        return this.draw3D;
    }

    public boolean getHasBar() {
        return this.hasBar;
    }

    public Rectangle getPlotRect() {
        return this.plotRect;
    }

    public Rectangle getChartAreaRect() {
        return this.chartAreaRect;
    }

    public ActionHandler getActionHandler() {
        return this.handler;
    }

    public boolean getInAction() {
        return this.inAction;
    }

    public void setInAction(boolean bl) {
        this.inAction = bl;
    }

    public JCAxis findAxisByName(String string) {
        JCAxis jCAxis = this.findAxisByName(string, true);
        if (jCAxis == null) {
            jCAxis = this.findAxisByName(string, false);
        }
        return jCAxis;
    }

    protected JCAxis findAxisByName(String string, boolean bl) {
        Vector vector;
        Vector vector2 = vector = bl ? this.xaxes : this.yaxes;
        if (vector == null) {
            return null;
        }
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!(e instanceof JCAxis) || !string.equals(((JCAxis)e).getName())) continue;
            return (JCAxis)e;
        }
        return null;
    }

    void layoutAnnotations(List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            jCAxis.layoutAnnotations();
            ++n;
        }
    }

    private void addDrawable(ChartDataView chartDataView) {
        if (chartDataView == null) {
            return;
        }
        if (this.hasMatchingDrawable(chartDataView)) {
            this.removeDrawable(chartDataView);
        }
        ChartDraw chartDraw = ChartDraw.makeDrawObject(chartDataView);
        this.drawables.put(chartDataView, chartDraw);
    }

    void removeDrawable(ChartDataView chartDataView) {
        if (this.drawables != null) {
            this.drawables.remove(chartDataView);
        }
    }

    void clearDrawables() {
        this.drawables = new Hashtable();
    }

    boolean hasMatchingDrawable(ChartDataView chartDataView) {
        if (this.drawables != null && this.drawables.containsKey(chartDataView)) {
            ChartDraw chartDraw = (ChartDraw)this.drawables.get(chartDataView);
            if (chartDraw.chartType == chartDraw.dataObject.getChartType()) {
                return true;
            }
        }
        return false;
    }

    public ChartDraw getDrawable(ChartDataView chartDataView) {
        ChartDraw chartDraw = null;
        if (this.drawables != null && this.drawables.containsKey(chartDataView)) {
            ChartDraw chartDraw2 = (ChartDraw)this.drawables.get(chartDataView);
            if (chartDraw2.chartType == chartDraw2.dataObject.getChartType()) {
                chartDraw = chartDraw2;
            }
        }
        return chartDraw;
    }

    void calcAnchors(List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            jCAxis.calcAnchors();
            ++n;
        }
    }

    void calcLimits() {
        this.clearLimits();
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        if (this.pieFirst) {
            Iterator iterator = jCChart.getOriginalDataView().iterator();
            while (iterator.hasNext()) {
                ChartDataView chartDataView = (ChartDataView)iterator.next();
                if (!chartDataView.isVisible() || chartDataView.getChartType() != 11) continue;
                chartDataView.calcLimits();
                break;
            }
        } else if (this.polarRadarFirst) {
            Iterator iterator = jCChart.getOriginalDataView().iterator();
            while (iterator.hasNext()) {
                ChartDataView chartDataView = (ChartDataView)iterator.next();
                int n = chartDataView.getChartType();
                if (!chartDataView.isVisible() || n != 2 && n != 3 && n != 4) continue;
                chartDataView.calcLimits();
                break;
            }
        } else {
            Iterator iterator = jCChart.getOriginalDataView().iterator();
            while (iterator.hasNext()) {
                ChartDataView chartDataView = (ChartDataView)iterator.next();
                int n = chartDataView.getChartType();
                if (n == 11 || n == 2 || n == 3 || n == 4 || !chartDataView.isVisible()) continue;
                chartDataView.calcLimits();
            }
        }
    }

    void clearLimits() {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        Iterator iterator = jCChart.getOriginalDataView().iterator();
        while (iterator.hasNext()) {
            ChartDataView chartDataView = (ChartDataView)iterator.next();
            chartDataView.clearLimits();
        }
    }

    void cancel() {
        this.handler = null;
        this.inAction = false;
        this.setChanged(true, 2);
    }

    void reset() {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        boolean bl = jCChart.isBatched();
        jCChart.setBatched(true);
        if (this.horizActionAxis != null) {
            this.horizActionAxis.min.isDefault = true;
            this.horizActionAxis.max.isDefault = true;
            this.horizActionAxis.setChanged(true, 2, false);
            jCChart.sendEvent(this.horizActionAxis);
        }
        if (this.vertActionAxis != null) {
            this.vertActionAxis.min.isDefault = true;
            this.vertActionAxis.max.isDefault = true;
            this.vertActionAxis.setChanged(true, 2, false);
            jCChart.sendEvent(this.vertActionAxis);
        }
        this.cancel();
        jCChart.setBatched(bl);
    }

    void drawRubberBand(Point point, Point point2) {
        int n;
        Graphics graphics;
        if (point == null) {
            return;
        }
        if (point.x == point2.x || point.y == point2.y) {
            return;
        }
        int n2 = point2.x;
        int n3 = point2.y;
        int n4 = point.x;
        int n5 = point.y;
        if (this.rbGC == null && this.getParent() == null) {
            return;
        }
        Graphics graphics2 = graphics = this.rbGC == null ? this.getGraphics().create() : this.rbGC.create();
        if (n4 - n2 < 0) {
            n = n4;
            n4 = n2;
            n2 = n;
        }
        if (n5 - n3 < 0) {
            n = n5;
            n5 = n3;
            n3 = n;
        }
        graphics.setXORMode(Color.white);
        graphics.drawRect(n2, n3, n4 - n2, n5 - n3);
        graphics.setXORMode(Color.black);
        graphics.drawRect(n2 + 1, n3 + 1, n4 - n2, n5 - n3);
        graphics.dispose();
    }

    void drawRubberLine(Point point, Point point2) {
        if (point == null || point2 == null) {
            return;
        }
        if (this.getParent() == null) {
            return;
        }
        Graphics graphics = this.getGraphics().create();
        graphics.setXORMode(Color.white);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.setXORMode(Color.black);
        graphics.drawLine(point.x + 1, point.y + 1, point2.x + 1, point2.y + 1);
        graphics.dispose();
    }

    JCDataIndex pick(Point point, ChartDataView chartDataView, int n) {
        Changeable changeable;
        Object object;
        Object object2;
        JCDataIndex jCDataIndex = null;
        ChartDraw chartDraw = null;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return null;
        }
        if (chartDataView != null) {
            chartDraw = this.getDrawable(chartDataView);
            if (chartDraw != null) {
                jCDataIndex = chartDraw.pick(point, n == -1 ? chartDataView.getPickFocus() : n);
            }
            if (jCDataIndex != null) {
                jCDataIndex.obj = this;
                jCDataIndex.dataView = chartDataView;
            }
            return jCDataIndex;
        }
        List list = jCChart.getOriginalDataView();
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            object2 = (ChartDataView)listIterator.previous();
            object = this.getDrawable((ChartDataView)object2);
            if (object == null || ((ChartDataView)object2).is3DChartType() || !((ChartDraw)object).drawFront) continue;
            jCDataIndex = this.pickOne((ChartDraw)object, point, n, jCDataIndex);
        }
        object2 = list.listIterator(list.size());
        while (object2.hasPrevious()) {
            object = (ChartDataView)object2.previous();
            changeable = this.getDrawable((ChartDataView)object);
            if (changeable == null || !((ChartDataView)object).is3DChartType()) continue;
            jCDataIndex = this.pickOne((ChartDraw)changeable, point, n, jCDataIndex);
        }
        object = list.listIterator(list.size());
        while (object.hasPrevious()) {
            changeable = (ChartDataView)object.previous();
            ChartDraw chartDraw2 = this.getDrawable((ChartDataView)changeable);
            if (chartDraw2 == null || chartDraw2.drawFront || ((ChartDataView)changeable).is3DChartType()) continue;
            jCDataIndex = this.pickOne(chartDraw2, point, n, jCDataIndex);
        }
        return jCDataIndex;
    }

    private JCDataIndex pickOne(ChartDraw chartDraw, Point point, int n, JCDataIndex jCDataIndex) {
        JCDataIndex jCDataIndex2 = chartDraw.pick(point, n == -1 ? chartDraw.dataObject.getPickFocus() : n);
        if (jCDataIndex2 != null) {
            jCDataIndex2.obj = this;
            jCDataIndex2.dataView = chartDraw.dataObject;
        }
        if (jCDataIndex == null) {
            jCDataIndex = jCDataIndex2;
        } else if (jCDataIndex2 != null && jCDataIndex.distance > jCDataIndex2.distance) {
            jCDataIndex = jCDataIndex2;
        }
        return jCDataIndex;
    }

    boolean isXAxis(JCAxis jCAxis) {
        return this.xaxes.contains(jCAxis);
    }

    private boolean is3DChartType(int n) {
        return n == 9 || n == 10;
    }

    private void getHorizVertAxes(List list, List list2) {
        int n = 0;
        while (n < this.xaxes.size()) {
            JCAxis jCAxis = (JCAxis)this.xaxes.get(n);
            if (jCAxis.vertical) {
                list2.add(jCAxis);
            } else {
                list.add(jCAxis);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.yaxes.size()) {
            JCAxis jCAxis = (JCAxis)this.yaxes.get(n2);
            if (jCAxis.vertical) {
                list2.add(jCAxis);
            } else {
                list.add(jCAxis);
            }
            ++n2;
        }
    }

    private void drawWebBoundingBox(Graphics graphics, JCLineStyle jCLineStyle, JCAxis jCAxis) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        List list = jCChart.getOriginalDataView();
        ChartDataView chartDataView = null;
        if (list != null) {
            chartDataView = (ChartDataView)list.get(0);
            int[] nArray = ChartDataView.getFirstLastPoints(chartDataView);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = n2 - n + 1;
            double d = Math.rint(jCAxis.polarAxisParams.radius);
            jCAxis.drawWebLine(graphics, jCLineStyle, d, n3);
        }
    }

    private void fillWebRegion(Graphics graphics, JCFillStyle jCFillStyle, JCAxis jCAxis) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        List list = jCChart.getOriginalDataView();
        ChartDataView chartDataView = null;
        if (list != null) {
            chartDataView = (ChartDataView)list.get(0);
            int[] nArray = ChartDataView.getFirstLastPoints(chartDataView);
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = n2 - n + 1;
            double d = JCChartUtil.getRadarAngle(2, n3, 1, false);
            Polygon polygon = new Polygon();
            double d2 = Math.rint(jCAxis.polarAxisParams.radius);
            Point point = null;
            int n4 = 0;
            while (n4 < n3) {
                point = jCAxis.toPixelPolar(d * (double)n4, d2, false);
                polygon.addPoint(point.x, point.y);
                ++n4;
            }
            jCFillStyle.fillPolygon(graphics, polygon);
        }
    }

    private void drawBackplane(Graphics graphics) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        List list = jCChart.getOriginalDataView();
        ChartDataView chartDataView = null;
        if (list != null) {
            chartDataView = (ChartDataView)list.get(0);
            if (list.size() == 1 && chartDataView != null && chartDataView.getChartType() == 11) {
                return;
            }
        }
        JCFillStyle jCFillStyle = null;
        if (this.isOpaque()) {
            Color color = this.plotArea.getBackground();
            jCFillStyle = new JCFillStyle(this.plotArea.getBackground(), 1);
        }
        int n = this.plotRect.x;
        int n2 = this.plotRect.y;
        int n3 = this.plotRect.width;
        int n4 = this.plotRect.height;
        int n5 = chartDataView == null ? -1 : chartDataView.getChartType();
        boolean bl = n5 == 2;
        boolean bl2 = n5 == 3 || n5 == 4;
        JCAxis jCAxis = chartDataView == null ? null : chartDataView.getXAxis();
        boolean bl3 = false;
        if ((bl || bl2) && jCAxis != null) {
            bl3 = jCAxis.polarAxisParams.isCircularGrid();
        }
        if (bl || bl2 && bl3) {
            if (jCAxis != null) {
                if (jCFillStyle != null) {
                    jCFillStyle.fillCircle(graphics, (int)Math.round(jCAxis.polarAxisParams.xCenter), (int)Math.round(jCAxis.polarAxisParams.yCenter), (int)Math.round(jCAxis.polarAxisParams.radius));
                }
                if (this.axisBoundingBox && (bl2 || bl && !jCAxis.isVisible())) {
                    Color color = this.plotArea.getForeground();
                    JCLineStyle jCLineStyle = new JCLineStyle(1, color, 1);
                    jCLineStyle.drawCircle(graphics, (int)Math.round(jCAxis.polarAxisParams.xCenter), (int)Math.round(jCAxis.polarAxisParams.yCenter), (int)Math.round(jCAxis.polarAxisParams.radius));
                }
            }
        } else if (bl2 && !bl3) {
            if (jCAxis != null) {
                if (jCFillStyle != null) {
                    this.fillWebRegion(graphics, jCFillStyle, jCAxis);
                }
                if (this.axisBoundingBox) {
                    Color color = this.plotArea.getForeground();
                    JCLineStyle jCLineStyle = new JCLineStyle(1, color, 1);
                    graphics.setColor(color);
                    this.drawWebBoundingBox(graphics, jCLineStyle, jCAxis);
                }
            }
        } else if ((this.draw3D || this.axisBoundingBox) && !this.pieFirst) {
            if (this.draw3D && this.deltaX > 0) {
                n += this.deltaX;
            }
            if (this.draw3D && this.deltaY > 0) {
                n2 += this.deltaY;
            }
            int n6 = this.draw3D ? JCChartUtil.abs(this.deltaX) : 0;
            int n7 = this.draw3D ? JCChartUtil.abs(this.deltaY) : 0;
            n3 = Math.max(0, n3 - n6);
            n4 = Math.max(0, n4 - n7);
            if (jCFillStyle != null) {
                jCFillStyle.fillRect(graphics, n, n2, n3, n4);
            }
            if (this.axisBoundingBox) {
                graphics.setColor(this.plotArea.getForeground());
                graphics.drawRect(n, n2, n3, n4);
            }
            this.backplane = new Rectangle(n, n2, n3, n4);
        } else {
            if (jCFillStyle != null) {
                jCFillStyle.fillOutlineRect(graphics, n, n2, n3, n4, jCFillStyle.getColor());
            }
            this.backplane = new Rectangle(n, n2, n3, n4);
        }
    }

    private void drawAxes(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        boolean bl = this.isPolarRadar();
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            if ((!bl || jCAxis.isPolarRadar()) && jCAxis.visible) {
                jCAxis.draw(graphics);
            }
            ++n;
        }
    }

    private void drawBpAxes(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            if (jCAxis.visible && !jCAxis.isBar()) {
                jCAxis.draw(graphics);
            }
            ++n;
        }
    }

    private void drawFpAxes(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            if (jCAxis.visible && jCAxis.isBar()) {
                jCAxis.draw(graphics);
            }
            ++n;
        }
    }

    private void drawAxisAnnotationsAndTitle(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        boolean bl = this.isPolarRadar();
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            if ((!bl || jCAxis.isPolarRadar()) && jCAxis.visible) {
                jCAxis.drawAnnotationsAndTitle(graphics);
            }
            ++n;
        }
    }

    private void drawBpAxisAnnotationsAndTitle(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            if (jCAxis.visible && !jCAxis.isBar()) {
                jCAxis.drawAnnotationsAndTitle(graphics);
            }
            ++n;
        }
    }

    private void drawFpAxisAnnotationsAndTitle(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            if (jCAxis.visible && jCAxis.isBar()) {
                jCAxis.drawAnnotationsAndTitle(graphics);
            }
            ++n;
        }
    }

    private void preDraw3DAxes(Graphics graphics, JCAxis jCAxis, JCAxis jCAxis2) {
        if (jCAxis == null || jCAxis2 == null) {
            return;
        }
        boolean bl = jCAxis.vertical;
        int n = jCAxis.getPlacement();
        int n2 = jCAxis2.getPlacement();
        if (n == 5) {
            if (jCAxis2.getOrigin() == jCAxis2.getMax()) {
                n = 2;
            } else if (jCAxis2.getOrigin() == jCAxis2.getMin()) {
                n = 1;
            }
        } else if (n == 4) {
            if (jCAxis.getPlacementLocation() == jCAxis2.getMax()) {
                n = 2;
            } else if (jCAxis.getPlacementLocation() == jCAxis2.getMin()) {
                n = 1;
            }
        }
        if (n2 == 5) {
            if (jCAxis.getOrigin() == jCAxis.getMax()) {
                n2 = 2;
            } else if (jCAxis.getOrigin() == jCAxis.getMin()) {
                n2 = 1;
            }
        } else if (n2 == 4) {
            if (jCAxis2.getPlacementLocation() == jCAxis.getMax()) {
                n2 = 2;
            } else if (jCAxis2.getPlacementLocation() == jCAxis.getMin()) {
                n2 = 1;
            }
        }
        if (jCAxis.isReversed()) {
            if (n2 == 1) {
                n2 = 2;
            } else if (n2 == 2) {
                n2 = 1;
            }
        }
        if (jCAxis2.isReversed()) {
            if (n == 1) {
                n = 2;
            } else if (n == 2) {
                n = 1;
            }
        }
        if (jCAxis.visible) {
            jCAxis.preDrawCalc();
        }
        if (jCAxis2.visible) {
            jCAxis2.preDrawCalc();
        }
        if (this.deltaX >= 0 && this.deltaY < 0) {
            if (n2 != 1 && n2 != 2 && n != 1 && n != 2) {
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, false, true);
                }
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, false, false);
                }
            } else if (n2 == 2 || n2 != 2 && n2 != 1 && (bl ? n == 1 : n != 2)) {
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, true, false);
                }
            } else {
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, true, false);
                }
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
            }
        } else if (this.deltaX < 0 && this.deltaY >= 0) {
            if (n2 != 1 && n2 != 2 && n != 1 && n != 2) {
                if (jCAxis2.visible) {
                    jCAxis.preDraw(graphics, false, false);
                }
                if (jCAxis.visible) {
                    jCAxis2.preDraw(graphics, true, false);
                }
                if (jCAxis2.visible) {
                    jCAxis.preDraw(graphics, false, true);
                }
            } else if (n2 == 1 || n2 != 2 && n2 != 1 && (bl ? n != 1 : n == 2)) {
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, true, false);
                }
            } else {
                if (jCAxis2.visible) {
                    jCAxis2.preDraw(graphics, true, false);
                }
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
            }
        } else {
            if (jCAxis.visible) {
                jCAxis.preDraw(graphics, true, false);
            }
            if (jCAxis2.visible) {
                jCAxis2.preDraw(graphics, true, false);
            }
        }
    }

    private void preDrawGrids(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        boolean bl = this.isPolarRadar();
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            if ((!bl || jCAxis.isPolarRadar()) && jCAxis.visible) {
                jCAxis.drawGrid(graphics);
            }
            ++n;
        }
    }

    private void adjustPlotRectForAxes(List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n5);
            if (jCAxis.visible && !this.pieFirst && !this.polarRadarFirst) {
                if (jCAxis.vertical) {
                    if (jCAxis.annoHandler.extents.ortho > jCAxis.getWidth()) {
                        jCAxis.setSize(jCAxis.annoHandler.extents.ortho, jCAxis.getHeight());
                    }
                    if (jCAxis.isLeftSide()) {
                        n = this.draw3D ? Math.max(n, jCAxis.getWidth()) : (n += jCAxis.getWidth());
                    } else if (jCAxis.isRightSide()) {
                        n2 = this.draw3D ? Math.max(n2, jCAxis.getWidth()) : (n2 += jCAxis.getWidth());
                    }
                } else {
                    if (jCAxis.annoHandler.extents.ortho > jCAxis.getHeight()) {
                        jCAxis.setSize(jCAxis.getWidth(), jCAxis.annoHandler.extents.ortho);
                    }
                    if (jCAxis.isTopSide()) {
                        n3 = this.draw3D ? Math.max(n3, jCAxis.getHeight()) : (n3 += jCAxis.getHeight());
                    } else if (jCAxis.isBottomSide()) {
                        n4 = this.draw3D ? Math.max(n4, jCAxis.getHeight()) : (n4 += jCAxis.getHeight());
                    }
                }
            }
            ++n5;
        }
        if (!this.getPlotArea().getLeftIsDefault()) {
            this.plotRect.x = this.getPlotArea().getLeft();
        }
        if (!this.getPlotArea().getTopIsDefault()) {
            this.plotRect.y = this.getPlotArea().getTop();
        }
        int n6 = this.plotRect.x;
        int n7 = this.getPlotArea().getRightIsDefault() ? this.plotRect.x + this.plotRect.width : this.chartAreaRect.width - this.getPlotArea().getRight();
        int n8 = this.plotRect.y;
        int n9 = this.getPlotArea().getBottomIsDefault() ? this.plotRect.y + this.plotRect.height : this.chartAreaRect.height - this.getPlotArea().getBottom();
        int n10 = 0;
        while (n10 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n10);
            if (jCAxis.visible && !this.pieFirst && !this.polarRadarFirst) {
                if (jCAxis.vertical) {
                    if (jCAxis.isLeftSide()) {
                        if (this.getPlotArea().getLeftIsDefault()) {
                            if (this.draw3D) {
                                jCAxis.setLocation(n6 + n - jCAxis.getWidth(), jCAxis.getTop());
                            } else {
                                jCAxis.setLocation(n6, jCAxis.getTop());
                                n6 += jCAxis.getWidth();
                            }
                        } else if (this.draw3D) {
                            jCAxis.setLocation(n6 - jCAxis.getWidth(), jCAxis.getTop());
                        } else {
                            jCAxis.setLocation(n6 - n, jCAxis.getTop());
                            n6 += jCAxis.getWidth();
                        }
                    } else if (jCAxis.isRightSide()) {
                        if (this.getPlotArea().getRightIsDefault()) {
                            if (this.draw3D) {
                                jCAxis.setLocation(n7 - n2, jCAxis.getTop());
                            } else {
                                jCAxis.setLocation(n7 - n2, jCAxis.getTop());
                                n7 += jCAxis.getWidth();
                            }
                        } else if (this.draw3D) {
                            jCAxis.setLocation(n7, jCAxis.getTop());
                        } else {
                            jCAxis.setLocation(n7, jCAxis.getTop());
                            n7 += jCAxis.getWidth();
                        }
                    }
                } else if (jCAxis.isTopSide()) {
                    if (this.getPlotArea().getTopIsDefault()) {
                        if (this.draw3D) {
                            jCAxis.setLocation(jCAxis.getLeft(), n8 + n3 - jCAxis.getHeight());
                        } else {
                            jCAxis.setLocation(jCAxis.getLeft(), n8);
                            n8 += jCAxis.getHeight();
                        }
                    } else if (this.draw3D) {
                        jCAxis.setLocation(jCAxis.getLeft(), n8 - jCAxis.getHeight());
                    } else {
                        jCAxis.setLocation(jCAxis.getLeft(), n8 - n3);
                        n8 += jCAxis.getHeight();
                    }
                } else if (jCAxis.isBottomSide()) {
                    if (this.getPlotArea().getBottomIsDefault()) {
                        if (this.draw3D) {
                            jCAxis.setLocation(jCAxis.getLeft(), n9 - n4);
                        } else {
                            jCAxis.setLocation(jCAxis.getLeft(), n9 - n4);
                            n9 += jCAxis.getHeight();
                        }
                    } else if (this.draw3D) {
                        jCAxis.setLocation(jCAxis.getLeft(), n9);
                    } else {
                        jCAxis.setLocation(jCAxis.getLeft(), n9);
                        n9 += jCAxis.getHeight();
                    }
                }
            }
            ++n10;
        }
        if (this.getPlotArea().getLeftIsDefault()) {
            this.plotRect.x += n;
            this.plotRect.width -= n;
        }
        if (this.getPlotArea().getRightIsDefault()) {
            this.plotRect.width -= n2;
        }
        if (this.getPlotArea().getTopIsDefault()) {
            this.plotRect.y += n3;
            this.plotRect.height -= n3;
        }
        if (this.getPlotArea().getBottomIsDefault()) {
            this.plotRect.height -= n4;
        }
    }

    private void adjustForSymbols(List list, List list2) {
        int n;
        if (this.getPlotArea().getLeftIsDefault() && (n = this.symbolPad - (this.plotRect.x - this.chartAreaRect.x)) > 0) {
            this.plotRect.x += n;
            this.plotRect.width -= n;
            this.adjust(list, n, 0, -n, 0);
            this.adjust(list2, n, 0, 0, 0, 1);
        }
        if (this.getPlotArea().getRightIsDefault() && (n = this.symbolPad - (this.chartAreaRect.x + this.chartAreaRect.width - this.plotRect.x - this.plotRect.width)) > 0) {
            this.plotRect.width -= n;
            this.adjust(list, 0, 0, -n, 0);
            this.adjust(list2, -n, 0, 0, 0, 2);
        }
        if (this.getPlotArea().getTopIsDefault() && (n = this.symbolPad - (this.plotRect.y - this.chartAreaRect.y)) > 0) {
            this.plotRect.y += n;
            this.plotRect.height -= n;
            this.adjust(list2, 0, n, 0, -n);
            this.adjust(list, 0, n, 0, 0, 2);
        }
        if (this.getPlotArea().getBottomIsDefault() && (n = this.symbolPad - (this.chartAreaRect.y + this.chartAreaRect.height - this.plotRect.y - this.plotRect.height)) > 0) {
            this.plotRect.height -= n;
            this.adjust(list2, 0, -n, 0, -n);
            this.adjust(list, 0, -n, 0, 0, 1);
        }
    }

    private void layoutAxes(List list, boolean bl) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            jCAxis.layoutAxis(bl);
            ++n;
        }
    }

    private void layoutOrigins(List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            jCAxis.layoutOrigin();
            ++n;
        }
    }

    void checkAnnotations(List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            jCAxis.checkAnnotations();
            ++n;
        }
    }

    private void ensureDrawables() {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        if (this.drawables == null) {
            this.drawables = new Hashtable();
        }
        this.axisDrawOkay = true;
        this.pieFirst = false;
        this.polarRadarFirst = false;
        int n = 0;
        Iterator iterator = jCChart.getOriginalDataView().iterator();
        while (iterator.hasNext()) {
            ChartDataView chartDataView = (ChartDataView)iterator.next();
            if (chartDataView.isVisible()) {
                if (++n == 1 && chartDataView.getChartType() == 11) {
                    this.pieFirst = true;
                    this.axisDrawOkay = false;
                } else if (n == 1 && (chartDataView.getChartType() == 2 || chartDataView.getChartType() == 3 || chartDataView.getChartType() == 4)) {
                    this.polarRadarFirst = true;
                }
            }
            if (!this.hasMatchingDrawable(chartDataView) && chartDataView.isVisible()) {
                this.addDrawable(chartDataView);
                continue;
            }
            if (!this.hasMatchingDrawable(chartDataView) || chartDataView.isVisible()) continue;
            this.removeDrawable(chartDataView);
        }
    }

    private void calcAxisParams(List list) {
        if (list == null) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            if (jCAxis.formula != null) {
                bl = true;
            }
            jCAxis.calcAxisParams(true);
            ++n;
        }
        if (!bl) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            if (jCAxis.formula != null) {
                jCAxis.formula.calcRelatedParams();
            }
            ++n2;
        }
    }

    private void makeAnnotations(List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            jCAxis.makeAnnotations();
            ++n;
        }
    }

    private void calcAnnotationExtents(List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            jCAxis.calcAnnotationExtents();
            ++n;
        }
    }

    private void calcGraphExtents() {
        if (this.drawables == null) {
            return;
        }
        if (this.pieFirst) {
            Enumeration enumeration = this.drawables.keys();
            while (enumeration.hasMoreElements()) {
                ChartDataView chartDataView = (ChartDataView)enumeration.nextElement();
                if (chartDataView.getChartType() != 11) continue;
                ChartDraw chartDraw = (ChartDraw)this.drawables.get(chartDataView);
                chartDraw.recalc();
                break;
            }
        } else if (this.polarRadarFirst) {
            Enumeration enumeration = this.drawables.keys();
            while (enumeration.hasMoreElements()) {
                ChartDataView chartDataView = (ChartDataView)enumeration.nextElement();
                int n = chartDataView.getChartType();
                if (n != 2 && n != 3 && n != 4) continue;
                ChartDraw chartDraw = (ChartDraw)this.drawables.get(chartDataView);
                chartDraw.recalc();
                break;
            }
        } else {
            Enumeration enumeration = this.drawables.keys();
            while (enumeration.hasMoreElements()) {
                ChartDataView chartDataView = (ChartDataView)enumeration.nextElement();
                int n = chartDataView.getChartType();
                if (n == 11 || n == 2 || n == 3 || n == 4) continue;
                ChartDraw chartDraw = (ChartDraw)this.drawables.get(chartDataView);
                chartDraw.recalc();
            }
        }
    }

    private void calcTransformation(List list) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            jCAxis.calcTransformation();
            ++n;
        }
    }

    private void adjustForExtents(List list, List list2) {
        Extents extents = new Extents();
        Extents extents2 = new Extents();
        this.findMaxExtents(list, extents);
        this.findMaxExtents(list2, extents2);
        int n = extents.minor - this.plotRect.x;
        if (n > 0 && this.plotArea.left.isDefault) {
            this.plotRect.width -= n;
            this.plotRect.x += n;
            this.adjust(list, n, 0, -n, 0);
            this.adjust(list2, n, 0, 0, 0, 1);
        }
        if ((n = extents.major - (this.chartAreaRect.width - this.plotRect.x - this.plotRect.width)) > 0 && this.plotArea.right.isDefault) {
            this.plotRect.width -= n;
            this.adjust(list, 0, 0, -n, 0);
            this.adjust(list2, -n, 0, 0, 0, 2);
        }
        if ((n = extents2.major - (this.chartAreaRect.height - this.plotRect.y - this.plotRect.height)) > 0 && this.plotArea.bottom.isDefault) {
            this.plotRect.height -= n;
            this.adjust(list2, 0, -n, 0, -n);
            this.adjust(list, 0, -n, 0, 0, 1);
        }
        if ((n = extents2.minor - this.plotRect.y) > 0 && this.plotArea.top.isDefault) {
            this.plotRect.y += n;
            this.plotRect.height -= n;
            this.adjust(list2, 0, n, 0, -n);
            this.adjust(list, 0, n, 0, 0, 2);
        }
    }

    private void adjustForOrthoExtents(List list, List list2) {
        Rectangle rectangle = new Rectangle(this.plotRect.x, this.plotRect.y, this.plotRect.width, this.plotRect.height);
        int n = 0;
        while (n < list.size()) {
            ((JCAxis)list.get(n)).adjustForOrthoExtent();
            ++n;
        }
        int n2 = 0;
        while (n2 < list2.size()) {
            ((JCAxis)list2.get(n2)).adjustForOrthoExtent();
            ++n2;
        }
        if (this.plotRect.equals(rectangle)) {
            return;
        }
        this.adjust(list2, 0, this.plotRect.y - rectangle.y, 0, this.plotRect.height - rectangle.height);
        this.adjust(list, this.plotRect.x - rectangle.x, 0, this.plotRect.width - rectangle.width, 0);
        this.layoutOrigins(list);
        this.layoutOrigins(list2);
    }

    private void findMaxExtents(List list, Extents extents) {
        if (list == null) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n);
            Extents extents2 = jCAxis.getExtents();
            if (extents2 != null) {
                if (extents2.major > extents.major) {
                    extents.major = extents2.major;
                }
                if (extents2.minor > extents.minor) {
                    extents.minor = extents2.minor;
                }
                if (extents2.ortho > extents.ortho) {
                    extents.ortho = extents2.ortho;
                }
            }
            ++n;
        }
    }

    private void adjust(List list, int n, int n2, int n3, int n4) {
        this.adjust(list, n, n2, n3, n4, 0);
    }

    private void adjust(List list, int n, int n2, int n3, int n4, int n5) {
        if (list == null) {
            return;
        }
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            return;
        }
        int n6 = 0;
        while (n6 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n6);
            if (n5 == 0 || n5 == jCAxis.getAdjustedRealPlacement()) {
                int n7 = jCAxis.getLeft() + n;
                int n8 = jCAxis.getTop() + n2;
                int n9 = jCAxis.getWidth() + n3;
                int n10 = jCAxis.getHeight() + n4;
                jCAxis.setBounds(n7, n8, n9, n10);
            }
            ++n6;
        }
    }

    private void calc3D() {
        List list;
        double d = JCChartUtil.degToRad(this.rotation);
        double d2 = JCChartUtil.degToRad(this.elevation);
        double d3 = Math.sin(d);
        double d4 = Math.sin(d2);
        double d5 = Math.cos(d2);
        double d6 = (double)this.depth / 100.0;
        double d7 = JCChartUtil.max(1.0, this.getSize().width);
        double d8 = (d7 /= 1.0 + JCChartUtil.abs(d3) * d5 * d6) * d6;
        this.deltaX = (int)(d8 * d3 * d5);
        this.deltaY = (int)(-d8 * d4);
        this.checkDeltaValues();
        boolean bl = true;
        boolean bl2 = true;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null && (list = jCChart.getDataView()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ChartDataView chartDataView = (ChartDataView)iterator.next();
                if (!chartDataView.isVisible()) continue;
                int n = chartDataView.getChartType();
                if (n != 0 && n != 1 && n != 12 && n != 8 && n != 5 && n != 6 && n != 7 && n != 2 && n != 3 && n != 4 && (n != 11 || bl2)) {
                    bl = false;
                    break;
                }
                if (!bl2) continue;
                bl2 = false;
            }
        }
        boolean bl3 = this.deltaX != 0 || this.deltaY != 0;
        this.hasBar = !bl;
        this.draw3D = !bl && bl3;
    }

    private boolean checkDeltaValues() {
        boolean bl = false;
        if (this.plotRect.width <= 0 || this.plotRect.height <= 0) {
            return bl;
        }
        int n = this.plotRect.width;
        if (Math.abs(this.deltaX) > n) {
            this.deltaX = this.deltaX < 0 ? -n : n;
            bl = true;
        }
        n = this.plotRect.height;
        if (Math.abs(this.deltaY) > n) {
            this.deltaY = this.deltaY < 0 ? -n : n;
            bl = true;
        }
        return bl;
    }

    private Rectangle clipToEntirePlotRect() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.axisBoundingBox && !this.draw3D) {
            n4 = this.plotRect.x + 1;
            n3 = this.plotRect.y + 1;
            n2 = this.plotRect.width - 1;
            n = this.plotRect.height - 1;
        } else {
            n4 = this.plotRect.x;
            n3 = this.plotRect.y;
            n2 = this.plotRect.width + 1;
            n = this.plotRect.height + 1;
        }
        n4 = Math.max(0, n4);
        n3 = Math.max(0, n3);
        n2 = Math.min(n2, this.chartAreaRect.width - n4);
        n = Math.min(n, this.chartAreaRect.height - n3);
        return new Rectangle(n4, n3, n2, n);
    }

    Rectangle clipForDrawing() {
        int n = this.symbolPad * 2;
        int n2 = Math.max(0, this.plotRect.x - n / 2);
        int n3 = Math.max(0, this.plotRect.y - n / 2);
        int n4 = Math.min(this.plotRect.width + 1 + n, this.chartAreaRect.width - n2);
        int n5 = Math.min(this.plotRect.height + 1 + n, this.chartAreaRect.height - n3);
        return new Rectangle(n2, n3, n4, n5);
    }

    private void resetPlotArea() {
        this.chartAreaRect = this.getDrawingArea();
        if (this.plotArea.top.isDefault) {
            this.plotArea.top.value = 0;
        }
        if (this.plotArea.left.isDefault) {
            this.plotArea.left.value = 0;
        }
        if (this.plotArea.bottom.isDefault) {
            this.plotArea.bottom.value = 0;
        }
        if (this.plotArea.right.isDefault) {
            this.plotArea.right.value = 0;
        }
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics;
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }
}

