/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.property.DataFileException;
import com.klg.jclass.chart.property.PropertyLoadFactory;
import com.klg.jclass.chart.property.PropertyLoadModel;
import com.klg.jclass.chart.property.PropertySaveFactory;
import com.klg.jclass.chart.property.PropertySaveModel;
import com.klg.jclass.chart.property.html.JCHTMLFileAccessor;
import com.klg.jclass.chart.property.html.JCHTMLFilePersistor;
import com.klg.jclass.chart.property.html.JCHTMLStringAccessor;
import com.klg.jclass.chart.property.html.JCHTMLStringPersistor;
import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JCChartFactory {
    public static final int HTML = 0;
    public static final int NO_DATA = 0;
    public static final int EMBED_DATA = 1;
    public static final int DATA_FILE_TEXT = 2;
    public static final int DATA_FILE_XML = 3;

    public static JCChart makeChartFromStream(InputStream inputStream, String string, int n) throws IOException, DataFileException {
        JCChart jCChart = new JCChart();
        jCChart.setName(string);
        JCHTMLFileAccessor jCHTMLFileAccessor = null;
        switch (n) {
            case 0: {
                jCHTMLFileAccessor = new JCHTMLFileAccessor(inputStream, (Component)jCChart);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad chart file type");
            }
        }
        if (jCHTMLFileAccessor == null) {
            return null;
        }
        PropertyLoadModel propertyLoadModel = PropertyLoadFactory.makeLoader(jCChart, jCHTMLFileAccessor);
        if (propertyLoadModel != null) {
            propertyLoadModel.loadProperties(jCHTMLFileAccessor, null);
        }
        return jCChart;
    }

    public static JCChart makeChartFromFile(String string, String string2, int n) throws IOException, DataFileException {
        return JCChartFactory.makeChartFromStream(new FileInputStream(string), string2, n);
    }

    public static JCChart makeChartFromFile(String string, String string2) {
        JCChart jCChart = null;
        try {
            jCChart = JCChartFactory.makeChartFromFile(string, string2, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jCChart;
    }

    public static JCChart makeChartFromString(String string, String string2, int n) throws DataFileException {
        JCChart jCChart = new JCChart();
        jCChart.setName(string2);
        JCHTMLStringAccessor jCHTMLStringAccessor = null;
        switch (n) {
            case 0: {
                jCHTMLStringAccessor = new JCHTMLStringAccessor(string, jCChart);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad chart file type");
            }
        }
        if (jCHTMLStringAccessor == null) {
            return null;
        }
        PropertyLoadModel propertyLoadModel = PropertyLoadFactory.makeLoader(jCChart, jCHTMLStringAccessor);
        if (propertyLoadModel != null) {
            propertyLoadModel.loadProperties(jCHTMLStringAccessor, null);
        }
        return jCChart;
    }

    public static JCChart makeChartFromString(String string, String string2) {
        JCChart jCChart = null;
        try {
            jCChart = JCChartFactory.makeChartFromString(string, string2, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jCChart;
    }

    public static void saveChartToStream(JCChart jCChart, OutputStream outputStream, int n, int n2, String string) throws IOException {
        if (jCChart == null || outputStream == null) {
            return;
        }
        JCHTMLFilePersistor jCHTMLFilePersistor = null;
        switch (n) {
            case 0: {
                jCHTMLFilePersistor = new JCHTMLFilePersistor(outputStream, (Object)jCChart);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad chart file type");
            }
        }
        if (jCHTMLFilePersistor == null) {
            return;
        }
        jCHTMLFilePersistor.setDataSaveType(n2);
        jCHTMLFilePersistor.setDataFileName(string);
        PropertySaveModel propertySaveModel = PropertySaveFactory.makeSaver(jCChart, new JCChart(), PropertySaveFactory.getPackage(), jCHTMLFilePersistor.getSubDirectory(), jCHTMLFilePersistor.getType());
        if (propertySaveModel != null) {
            propertySaveModel.saveProperties(jCHTMLFilePersistor, null, 0);
        }
    }

    public static void saveChartToFile(JCChart jCChart, String string, int n, int n2, String string2) throws IOException {
        JCChartFactory.saveChartToStream(jCChart, new FileOutputStream(string), 0, n2, string2);
    }

    public static String saveChartToString(JCChart jCChart, int n, int n2, String string) {
        if (jCChart == null) {
            return null;
        }
        JCHTMLStringPersistor jCHTMLStringPersistor = null;
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 0: {
                jCHTMLStringPersistor = new JCHTMLStringPersistor(stringBuffer, jCChart);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad chart file type");
            }
        }
        if (jCHTMLStringPersistor == null) {
            return null;
        }
        jCHTMLStringPersistor.setDataSaveType(n2);
        jCHTMLStringPersistor.setDataFileName(string);
        PropertySaveModel propertySaveModel = PropertySaveFactory.makeSaver(jCChart, new JCChart(), PropertySaveFactory.getPackage(), jCHTMLStringPersistor.getSubDirectory(), jCHTMLStringPersistor.getType());
        if (propertySaveModel != null) {
            propertySaveModel.saveProperties(jCHTMLStringPersistor, null, 0);
        }
        return stringBuffer.toString();
    }
}

