/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.chart.RadarChartDraw;
import com.klg.jclass.util.graphics.DefineShape;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public class PolarChartDraw
extends ChartDraw {
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    private boolean isRadar = false;
    Line2D.Double perpendicular = null;
    Point prev = null;
    Point next = null;
    Point last = null;

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n, int n2) {
        this.recalc(n, n2, -1);
    }

    public void recalc(int n, int n2, int n3) {
        if (!this.isChanged()) {
            return;
        }
        boolean bl = false;
        if (n >= 0 && n2 >= 0 && n2 >= n) {
            bl = true;
        }
        if (n3 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.holeValue = this.dataObject.getHoleValue();
        this.inverted = this.xaxis.vertical;
        if (bl) {
            int n4 = 0;
            int n5 = this.seriesList.size();
            int n6 = n4;
            while (n6 < n5) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n6);
                if (chartDataViewSeries.isVisible() && chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                    double[] dArray = chartDataViewSeries.getY();
                    int n7 = n;
                    while (n7 <= n2) {
                        this.ylim.setMinMax(dArray[n7], this.holeValue, this.yaxis.isLogarithmic());
                        ++n7;
                    }
                }
                ++n6;
            }
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        } else if (n3 == -1 || n3 == 0) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1);
    }

    public void draw(Graphics graphics, int n, int n2) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        if (this.seriesList == null) {
            return;
        }
        boolean bl = false;
        if (n >= 0 && n2 >= 0 && n2 >= n) {
            bl = true;
        }
        Graphics graphics2 = graphics.create();
        DefineShape defineShape = null;
        DefineShape defineShape2 = null;
        if (graphics2 instanceof DefineShape) {
            defineShape = (DefineShape)((Object)graphics2);
            defineShape2 = (DefineShape)((Object)graphics);
        }
        int n3 = 0;
        int n4 = this.seriesList.size();
        int n5 = n3;
        while (n5 < n4) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n5);
            if (chartDataViewSeries.isVisible() && chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                JCChartStyle jCChartStyle;
                if (!bl) {
                    n = this.getFirstPoint(chartDataViewSeries);
                    n2 = this.getLastPoint(chartDataViewSeries);
                } else {
                    int n6 = chartDataViewSeries.getLastPoint();
                    if (n < n6) {
                        n = n6;
                    }
                }
                double[] dArray = chartDataViewSeries.getX();
                double[] dArray2 = chartDataViewSeries.getY();
                double d = 0.0;
                double d2 = this.holeValue;
                if (bl && n > 0) {
                    d = dArray[n - 1];
                    d2 = dArray2[n - 1];
                }
                if ((jCChartStyle = chartDataViewSeries.getStyle()) != null) {
                    PlotPoint plotPoint;
                    boolean bl2;
                    double d3;
                    double d4;
                    JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                    boolean bl3 = false;
                    if (!jCLineStyle.updateGraphics(graphics2)) {
                        bl3 = true;
                    }
                    Line2D.Double double_ = new Line2D.Double();
                    JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
                    boolean bl4 = jCSymbolStyle.getShape() == 0;
                    PlotPoint plotPoint2 = new PlotPoint();
                    int n7 = n2 - n + 1;
                    int n8 = n;
                    while (n8 <= n2) {
                        d4 = 0.0;
                        d3 = this.holeValue;
                        bl2 = this.yaxis.isLogarithmic();
                        d4 = dArray[n8];
                        d3 = dArray2[n8];
                        if (bl2 && d3 <= 0.0) {
                            d3 = this.holeValue;
                        }
                        plotPoint = this.getPlotPoint(n8 - n, n7, d4, d3);
                        if (!bl3 && plotPoint.valid) {
                            this.drawConnectingLine(graphics, graphics2, plotPoint, plotPoint2, jCLineStyle, defineShape, d, d2, d4, d3, double_);
                        }
                        if (plotPoint2.valid && plotPoint2.drawPoint && !bl4) {
                            Color color = null;
                            if (this.dataObject.getColorHandler() != null) {
                                color = this.dataObject.getColorHandler().getColor(d, d2);
                            }
                            if (defineShape2 != null) {
                                defineShape2.markShape(new JCDataIndex(n8 - 1, chartDataViewSeries));
                            }
                            jCSymbolStyle.draw(graphics, plotPoint2.px, plotPoint2.py, color);
                            if (defineShape2 != null) {
                                defineShape2.unmarkShape();
                            }
                        }
                        plotPoint2.px = plotPoint.px;
                        plotPoint2.py = plotPoint.py;
                        plotPoint2.drawPoint = plotPoint.drawPoint;
                        plotPoint2.valid = plotPoint.valid;
                        d = d4;
                        d2 = d3;
                        ++n8;
                    }
                    if (this instanceof RadarChartDraw) {
                        d4 = 0.0;
                        d3 = this.holeValue;
                        bl2 = this.yaxis.isLogarithmic();
                        d4 = dArray[n];
                        d3 = dArray2[n];
                        if (bl2 && d3 <= 0.0) {
                            d3 = this.holeValue;
                        }
                        plotPoint = this.getPlotPoint(0, n7, d4, d3);
                        if (!bl3 && plotPoint.valid) {
                            this.drawConnectingLine(graphics, graphics2, plotPoint, plotPoint2, jCLineStyle, defineShape, d, d2, d4, d3, double_);
                        }
                    }
                    if (plotPoint2.valid && plotPoint2.drawPoint && !bl4) {
                        Color color = null;
                        if (this.dataObject.getColorHandler() != null) {
                            color = this.dataObject.getColorHandler().getColor(d, d2);
                        }
                        if (defineShape2 != null) {
                            defineShape2.markShape(new JCDataIndex(n2, chartDataViewSeries));
                        }
                        jCSymbolStyle.draw(graphics, plotPoint2.px, plotPoint2.py, color);
                        if (defineShape2 != null) {
                            defineShape2.unmarkShape();
                        }
                    }
                }
            }
            ++n5;
        }
        graphics2.dispose();
    }

    protected int getFirstPoint(ChartDataViewSeries chartDataViewSeries) {
        return chartDataViewSeries.getFirstPoint();
    }

    protected int getLastPoint(ChartDataViewSeries chartDataViewSeries) {
        return chartDataViewSeries.getLastPoint();
    }

    protected void drawConnectingLine(Graphics graphics, Graphics graphics2, PlotPoint plotPoint, PlotPoint plotPoint2, JCLineStyle jCLineStyle, DefineShape defineShape, double d, double d2, double d3, double d4, Line2D.Double double_) {
        if (plotPoint2.valid) {
            Color color = null;
            if (this.dataObject.getColorHandler() != null) {
                color = this.dataObject.getColorHandler().getColor(d, d2, d3, d4);
                if (color == null) {
                    color = jCLineStyle.getColor();
                }
                if (!graphics2.getColor().equals(color)) {
                    graphics2.setColor(color);
                }
            }
            if (defineShape != null) {
                defineShape.beginShape();
            }
            double_.setLine(plotPoint2.px, plotPoint2.py, plotPoint.px, plotPoint.py);
            ((Graphics2D)graphics2).draw(double_);
            if (defineShape != null) {
                defineShape.endShape(true);
            }
        }
    }

    PlotPoint getPlotPoint(int n, int n2, double d, double d2) {
        PlotPoint plotPoint = new PlotPoint();
        if (this.xaxis != null && this.yaxis != null && d2 != this.holeValue) {
            Point point = null;
            int n3 = this.dataObject.getParent().chartArea.getAngleUnit();
            double d3 = JCChartUtil.convertAngle(n3, 2, d);
            point = this.yaxis.toPixelPolar(d3, d2, true);
            plotPoint.px = point.x;
            plotPoint.py = point.y;
            plotPoint.drawPoint = true;
            plotPoint.valid = true;
        } else {
            plotPoint.px = 2.147483647E9;
            plotPoint.py = 2.147483647E9;
            plotPoint.drawPoint = false;
            plotPoint.valid = false;
        }
        return plotPoint;
    }

    protected double getThetaValue(int n, int n2, int n3, double[] dArray) {
        return dArray[n];
    }

    public JCDataIndex pick(Point point, int n) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n2 = point.x - rectangle.x;
        int n3 = point.y - rectangle.y;
        JCDataCoord jCDataCoord = this.yaxis.toDataPolar(n2, n3);
        JCDataIndex jCDataIndex = null;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        int n4 = 0;
        int n5 = this.seriesList.size();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n6 = -1;
        int n7 = -1;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MAX_VALUE;
        int n8 = Integer.MAX_VALUE;
        try {
            int n9;
            int n10;
            JCDataIndex jCDataIndex2 = new JCDataIndex();
            int n11 = n4;
            while (n11 < n5) {
                d5 = this.findClosestPointPrimary(n, n11, jCDataIndex2, n2, n3, jCDataCoord);
                if (d5 < d4) {
                    d4 = d5;
                    n6 = n11;
                    n7 = jCDataIndex2.point;
                    n8 = jCDataIndex2.distance;
                }
                ++n11;
            }
            jCDataIndex2.seriesIndex = n6;
            jCDataIndex2.point = n7;
            jCDataIndex2.distance = n8;
            int n12 = -1;
            int n13 = -1;
            int n14 = Integer.MAX_VALUE;
            if (n != 0) {
                JCDataIndex jCDataIndex3 = new JCDataIndex();
                n10 = 0;
                n9 = n4;
                while (n9 < n5) {
                    n10 = this.findClosestPointSecondary(n, n9, jCDataIndex2, jCDataIndex3, n2, n3, jCDataCoord) ? 1 : 0;
                    if (n10 != 0 && jCDataIndex3.distance < n14) {
                        n14 = jCDataIndex3.distance;
                        n12 = n9;
                        n13 = jCDataIndex3.point;
                    }
                    ++n9;
                }
            }
            if (n6 >= 0 && n7 >= 0) {
                int n15 = n6;
                n10 = n7;
                n9 = n8;
                if (n12 >= 0 && n13 >= 0 && n14 < n8) {
                    n15 = n12;
                    n10 = n13;
                    n9 = n14;
                }
                jCDataIndex = new JCDataIndex(n10, (ChartDataViewSeries)this.seriesList.get(n15), n15);
                jCDataIndex.distance = n9;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    private double findClosestPointPrimary(int n, int n2, JCDataIndex jCDataIndex, int n3, int n4, JCDataCoord jCDataCoord) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
        if (chartDataViewSeries == null || !chartDataViewSeries.isVisible()) {
            return -1.0;
        }
        int n5 = this.getFirstPoint(chartDataViewSeries);
        int n6 = this.getLastPoint(chartDataViewSeries);
        if (n5 == Integer.MAX_VALUE || n6 == Integer.MAX_VALUE) {
            return -1.0;
        }
        double[] dArray = chartDataViewSeries.getX();
        double[] dArray2 = chartDataViewSeries.getY();
        this.isRadar = this instanceof RadarChartDraw;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = 2.147483647E9;
        int n7 = -1;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.holeValue;
        double d7 = this.holeValue;
        double d8 = 0.0;
        boolean bl = this.yaxis.isLogarithmic();
        int n8 = this.yaxis.chartArea.getAngleUnit();
        int n9 = n5;
        while (n9 <= n6) {
            d4 = this.getThetaValue(n9, n5, n6, dArray);
            d5 = dArray2[n9];
            if (!(d4 == this.holeValue || d5 == this.holeValue || d5 > this.ylim.max || bl && d5 <= 0.0)) {
                if (!this.isRadar && !this.yaxis.isReversed() && d5 < 0.0) {
                    d5 *= -1.0;
                    d4 += JCChartUtil.convertAngle(1, n8, 180.0);
                }
                d8 = JCChartUtil.boundAngle(n8, d4);
                d2 = Double.MAX_VALUE;
                switch (n) {
                    case 1: {
                        d2 = Math.abs(d8 - jCDataCoord.x);
                        d2 = Math.min(d2, JCChartUtil.boundAngle(n8, -d2));
                        break;
                    }
                    case 2: {
                        d2 = Math.abs(jCDataCoord.y - d5);
                        break;
                    }
                    default: {
                        d2 = this.calcXYDistance(n3, n4, d4, d5);
                    }
                }
                if (d2 < d) {
                    n7 = n9;
                    d6 = d4;
                    d7 = d5;
                    d = d2;
                }
            }
            ++n9;
        }
        jCDataIndex.seriesIndex = n2;
        jCDataIndex.point = n7;
        jCDataIndex.distance = n == 0 ? (int)Math.round(d) : (d6 != this.holeValue && d7 != this.holeValue ? (int)Math.round(this.calcXYDistance(n3, n4, d6, d7)) : Integer.MAX_VALUE);
        return d;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean findClosestPointSecondary(int n, int n2, JCDataIndex jCDataIndex, JCDataIndex jCDataIndex2, int n3, int n4, JCDataCoord jCDataCoord) {
        if (n != 1 && n != 2) {
            return false;
        }
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(jCDataIndex.seriesIndex);
        if (chartDataViewSeries == null) return false;
        if (!chartDataViewSeries.isVisible()) {
            return false;
        }
        double[] dArray = chartDataViewSeries.getX();
        double[] dArray2 = chartDataViewSeries.getY();
        double d = dArray[jCDataIndex.point];
        double d2 = dArray2[jCDataIndex.point];
        ChartDataViewSeries chartDataViewSeries2 = (ChartDataViewSeries)this.seriesList.get(n2);
        if (chartDataViewSeries2 == null) return false;
        if (!chartDataViewSeries2.isVisible()) {
            return false;
        }
        int n5 = this.getFirstPoint(chartDataViewSeries2);
        int n6 = this.getLastPoint(chartDataViewSeries2);
        if (n5 == Integer.MAX_VALUE) return false;
        if (n6 == Integer.MAX_VALUE) {
            return false;
        }
        double[] dArray3 = chartDataViewSeries2.getX();
        double[] dArray4 = chartDataViewSeries2.getY();
        this.isRadar = this instanceof RadarChartDraw;
        int n7 = -1;
        double d3 = 2.147483647E9;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.holeValue;
        double d7 = this.holeValue;
        double d8 = 0.0;
        boolean bl = this.yaxis.isLogarithmic();
        int n8 = this.yaxis.chartArea.getAngleUnit();
        int n9 = n5;
        while (n9 <= n6) {
            block13: {
                d4 = this.getThetaValue(n9, n5, n6, dArray3);
                d5 = dArray4[n9];
                if (d4 == this.holeValue || d5 == this.holeValue || d5 > this.ylim.max || bl && d5 <= 0.0) break block13;
                if (!this.isRadar && !this.yaxis.isReversed() && d5 < 0.0) {
                    d5 *= -1.0;
                    d4 += JCChartUtil.convertAngle(1, n8, 180.0);
                }
                d8 = JCChartUtil.boundAngle(n8, d4);
                double d9 = Double.MAX_VALUE;
                switch (n) {
                    case 1: {
                        if (d4 == d) {
                            d9 = Math.abs(jCDataCoord.y - d5);
                            break;
                        }
                        break block13;
                    }
                    case 2: {
                        if (d5 != d2) break block13;
                        d9 = Math.abs(d8 - jCDataCoord.x);
                        d9 = Math.min(d9, JCChartUtil.boundAngle(n8, -d9));
                    }
                }
                if (d9 < d3) {
                    n7 = n9;
                    d3 = d9;
                    d6 = d4;
                    d7 = d5;
                }
            }
            ++n9;
        }
        jCDataIndex2.seriesIndex = n2;
        jCDataIndex2.point = n7;
        if (d6 != this.holeValue && d7 != this.holeValue) {
            jCDataIndex2.distance = (int)this.calcXYDistance(n3, n4, d6, d7);
            return true;
        }
        jCDataIndex2.distance = Integer.MAX_VALUE;
        return true;
    }

    protected JCDataIndex findClosestPointInSeries(int n, int n2, int n3, int n4, JCDataCoord jCDataCoord) {
        this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        JCDataIndex jCDataIndex = null;
        JCDataIndex jCDataIndex2 = new JCDataIndex();
        jCDataIndex2.setSeries(this.dataObject.getSeries(n));
        double d = this.findClosestPointPrimary(n2, n, jCDataIndex2, n3, n4, jCDataCoord);
        if (d >= 0.0) {
            if (n2 != 0) {
                JCDataIndex jCDataIndex3 = new JCDataIndex();
                jCDataIndex3.setSeries(this.dataObject.getSeries(n));
                boolean bl = this.findClosestPointSecondary(n2, n, jCDataIndex2, jCDataIndex3, n3, n4, jCDataCoord);
                jCDataIndex = bl && jCDataIndex3.distance < jCDataIndex2.distance ? jCDataIndex3 : jCDataIndex2;
            } else {
                jCDataIndex = jCDataIndex2;
            }
        }
        return jCDataIndex;
    }

    private double calcXYDistance(int n, int n2, double d, double d2) {
        int n3 = this.dataObject.getParent().chartArea.getAngleUnit();
        double d3 = this.isRadar ? d : JCChartUtil.convertAngle(n3, 2, d);
        Point point = this.yaxis.toPixelPolar(d3, d2, true);
        int n4 = point.x - n;
        int n5 = point.y - n2;
        return Math.sqrt(n4 * n4 + n5 * n5);
    }

    public Point unpick(int n, int n2) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n2);
        double d = chartDataViewSeries.getY(n);
        double d2 = chartDataViewSeries.getX(n);
        if (this.yaxis != null && d != this.holeValue && d2 != this.holeValue) {
            return this.yaxis.toPixelPolar(d2, d, true);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return;
        }
        int n = jCDataIndex.series.getDrawingOrder();
        this.last = null;
        this.next = null;
        this.prev = null;
        int n2 = jCDataIndex.point;
        double d = Double.MAX_VALUE;
        double d2 = jCDataIndex.series.getX(n2);
        double d3 = jCDataIndex.series.getY(n2);
        if (d2 != Double.MAX_VALUE && d3 != Double.MAX_VALUE && d2 != this.dataObject.getHoleValue() && d3 != this.dataObject.getHoleValue()) {
            d = JCChartUtil.convertAngle(this.chartArea.getAngleUnit(), 2, d2);
            double d4 = this.yaxis.isReversed() ? this.yaxis.min.value : this.yaxis.max.value;
            Point point = this.yaxis.toPixelPolar(JCChartUtil.boundAngle(2, d + 1.5707963267948966), d4, true);
            Point point2 = this.yaxis.toPixelPolar(JCChartUtil.boundAngle(2, d - 1.5707963267948966), d4, true);
            this.perpendicular = new Line2D.Double(point.x, point.y, point2.x, point2.y);
        }
        if (n2 - 1 >= jCDataIndex.series.getFirstPoint()) {
            d2 = jCDataIndex.series.getX(n2 - 1);
            d3 = jCDataIndex.series.getY(n2 - 1);
            if (d2 != Double.MAX_VALUE && d3 != Double.MAX_VALUE && d2 != this.dataObject.getHoleValue() && d3 != this.dataObject.getHoleValue()) {
                d = JCChartUtil.convertAngle(this.chartArea.getAngleUnit(), 2, d2);
                this.prev = this.yaxis.toPixelPolar(d, d3, true);
            }
        }
        if (n2 + 1 <= jCDataIndex.series.getLastPoint()) {
            d2 = jCDataIndex.series.getX(n2 + 1);
            d3 = jCDataIndex.series.getY(n2 + 1);
            if (d2 != Double.MAX_VALUE && d3 != Double.MAX_VALUE && d2 != this.dataObject.getHoleValue() && d3 != this.dataObject.getHoleValue()) {
                d = JCChartUtil.convertAngle(this.chartArea.getAngleUnit(), 2, d2);
                this.next = this.yaxis.toPixelPolar(d, d3, true);
            }
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || this.perpendicular == null) {
            return;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        double d = JCChartUtil.convertAngle(this.chartArea.getAngleUnit(), 2, jCDataIndex.series.getX(jCDataIndex.point));
        double d2 = this.perpendicular.ptLineDist(n, n2);
        int n3 = this.perpendicular.relativeCCW(n, n2);
        if (n3 == -1) {
            d2 *= -1.0;
        }
        JCAxis jCAxis = jCDataIndex.dataView.getYAxis();
        this.last = jCAxis.toPixelPolar(d, d2, false);
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    int endEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || this.perpendicular == null) {
            return Integer.MIN_VALUE;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        double d = this.perpendicular.ptLineDist(n, n2);
        int n3 = this.perpendicular.relativeCCW(n, n2);
        if (n3 == -1) {
            d *= -1.0;
        }
        return (int)Math.round(d);
    }
}

