/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.LabelledChartDataModel;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChartDataSourceUtil {
    private static int lowCharacterBound = 32;
    private static int highCharacterBound = 126;
    private static final String QUOTE = "'";
    private static final String NL = "\n";
    private static final String BLANK = " ";
    private static final String COMMENT = "#";
    private static final String commentLine1 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key167") + "\n";
    private static final String commentLine2 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key168") + "\n";
    private static final String commentLine3 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key169") + "\n";
    private static final String commentLine4 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key170") + "\n";

    public static void setCharacterBounds(int n, int n2) {
        if (n > n2 || n < 0) {
            throw new IllegalArgumentException("Illegal bounds - lower:" + n + " higher:" + n2);
        }
        lowCharacterBound = n;
        highCharacterBound = n2;
    }

    public static int getLowCharacterBound() {
        return lowCharacterBound;
    }

    public static int getHighCharacterBound() {
        return highCharacterBound;
    }

    public static double[][] generateSingleXSeries(int n) {
        double[][] dArray = new double[1][n];
        int n2 = 0;
        while (n2 < dArray[0].length) {
            dArray[0][n2] = n2;
            ++n2;
        }
        return dArray;
    }

    public static double[][] generateMultipleXSeries(double[][] dArray) {
        if (dArray == null || dArray.length < 0) {
            return null;
        }
        double[][] dArrayArray = new double[dArray.length][];
        int n = 0;
        while (n < dArrayArray.length) {
            dArrayArray[n] = new double[dArray[n].length];
            int n2 = 0;
            while (n2 < dArray[n].length) {
                dArrayArray[n][n2] = n2;
                ++n2;
            }
            ++n;
        }
        return dArrayArray;
    }

    public static String buildDataSourceString(ChartDataModel chartDataModel) {
        return ChartDataSourceUtil.buildDataSourceString(chartDataModel, true);
    }

    public static String buildDataSourceString(ChartDataModel chartDataModel, boolean bl) {
        Object object;
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0) {
            return "";
        }
        int n = chartDataModel.getNumSeries();
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string = null;
        if (chartDataModel instanceof LabelledChartDataModel) {
            LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
            stringArray = labelledChartDataModel.getPointLabels();
            stringArray2 = labelledChartDataModel.getSeriesLabels();
            string = labelledChartDataModel.getDataSourceName();
        }
        boolean bl2 = false;
        double d = Double.MAX_VALUE;
        if (chartDataModel instanceof HoleValueChartDataModel) {
            d = ((HoleValueChartDataModel)((Object)chartDataModel)).getHoleValue();
            bl2 = true;
        }
        double[][] dArrayArray = new double[n][];
        double[][] dArrayArray2 = new double[n][];
        int n2 = 0;
        while (n2 < n) {
            object = chartDataModel.getXSeries(n2);
            if (n2 == 0 || object != dArrayArray[0]) {
                dArrayArray[n2] = object;
            }
            dArrayArray2[n2] = chartDataModel.getYSeries(n2);
            ++n2;
        }
        if (dArrayArray.length > 1 && dArrayArray[1] == null) {
            object = dArrayArray[0];
            dArrayArray = new double[][]{(double[])object};
        }
        object = new StringBuffer();
        if (dArrayArray.length == 1) {
            int n3 = dArrayArray2.length;
            int n4 = dArrayArray2[0].length;
            ((StringBuffer)object).append(commentLine1);
            ((StringBuffer)object).append(commentLine2);
            ((StringBuffer)object).append(commentLine3);
            ((StringBuffer)object).append(commentLine4);
            ((StringBuffer)object).append("ARRAY ");
            if (string != null) {
                String string2 = bl ? ChartDataSourceUtil.expandText(string) : string;
                ((StringBuffer)object).append(QUOTE + string2 + QUOTE + BLANK);
            } else {
                ((StringBuffer)object).append("'' ");
            }
            ((StringBuffer)object).append(n3 + BLANK + n4 + BLANK + NL);
            if (bl2 && d != Double.MAX_VALUE) {
                ((StringBuffer)object).append("HOLE " + d + NL);
            }
            ChartDataSourceUtil.writePointLabels(stringArray, (StringBuffer)object, false, bl);
            ((StringBuffer)object).append("'' ");
            int n5 = 0;
            while (n5 < n4) {
                ((StringBuffer)object).append(dArrayArray[0][n5] + BLANK);
                ++n5;
            }
            ((StringBuffer)object).append(NL);
            int n6 = 0;
            while (n6 < n3) {
                if (stringArray2 != null && n6 < stringArray2.length && stringArray2[n6] != null) {
                    String string3 = bl ? ChartDataSourceUtil.expandText(stringArray2[n6]) : stringArray2[n6];
                    ((StringBuffer)object).append(QUOTE + string3 + QUOTE + BLANK);
                } else {
                    ((StringBuffer)object).append("'' ");
                }
                int n7 = 0;
                while (n7 < n4) {
                    if (bl2 && dArrayArray2[n6][n7] == d) {
                        ((StringBuffer)object).append("HOLE ");
                    } else {
                        ((StringBuffer)object).append(dArrayArray2[n6][n7] + BLANK);
                    }
                    ++n7;
                }
                ((StringBuffer)object).append(NL);
                ++n6;
            }
            ((StringBuffer)object).append(NL);
        } else {
            ((StringBuffer)object).append("GENERAL ");
            if (string != null) {
                ((StringBuffer)object).append(QUOTE + string + QUOTE + BLANK);
            } else {
                ((StringBuffer)object).append("'' ");
            }
            ((StringBuffer)object).append(dArrayArray2.length + BLANK);
            int n8 = 0;
            int n9 = 0;
            while (n9 < dArrayArray2.length) {
                if (dArrayArray2[n9] != null && dArrayArray2[n9].length > n8) {
                    n8 = dArrayArray2[n9].length;
                }
                ++n9;
            }
            ((StringBuffer)object).append(n8 + NL);
            if (bl2 && d != Double.MAX_VALUE) {
                ((StringBuffer)object).append("HOLE " + d + NL);
            }
            ChartDataSourceUtil.writePointLabels(stringArray, (StringBuffer)object, true, bl);
            int n10 = 0;
            while (n10 < dArrayArray2.length) {
                CharSequence charSequence;
                if (stringArray2 != null && n10 < stringArray2.length && stringArray2[n10] != null) {
                    charSequence = bl ? ChartDataSourceUtil.expandText(stringArray2[n10]) : stringArray2[n10];
                    ((StringBuffer)object).append(QUOTE + (String)charSequence + QUOTE + BLANK);
                } else {
                    ((StringBuffer)object).append("'' ");
                }
                if (dArrayArray2[n10] == null || dArrayArray2[n10].length <= 0) {
                    ((StringBuffer)object).append("0\n");
                } else {
                    ((StringBuffer)object).append(dArrayArray2[n10].length + NL);
                    charSequence = new StringBuffer();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n11 = 0;
                    while (n11 < dArrayArray2[n10].length) {
                        if (dArrayArray[n10] == null || n11 >= dArrayArray[n10].length) {
                            ((StringBuffer)charSequence).append(n11 + BLANK);
                        } else {
                            ((StringBuffer)charSequence).append(dArrayArray[n10][n11] + BLANK);
                        }
                        if (bl2 && dArrayArray2[n10][n11] == d) {
                            stringBuffer.append("HOLE ");
                        } else {
                            stringBuffer.append(dArrayArray2[n10][n11] + BLANK);
                        }
                        ++n11;
                    }
                    ((StringBuffer)object).append(charSequence + NL);
                    ((StringBuffer)object).append(stringBuffer + NL);
                }
                ++n10;
            }
        }
        return ((StringBuffer)object).toString();
    }

    public static boolean checkPointLabels(String[] stringArray) {
        boolean bl = false;
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && stringArray[n].length() > 0) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    private static void writePointLabels(String[] stringArray, StringBuffer stringBuffer, boolean bl, boolean bl2) {
        if (ChartDataSourceUtil.checkPointLabels(stringArray)) {
            if (bl) {
                stringBuffer.append("LABELS ");
            }
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    String string = bl2 ? ChartDataSourceUtil.expandText(stringArray[n]) : stringArray[n];
                    stringBuffer.append(QUOTE + string + QUOTE + BLANK);
                } else {
                    stringBuffer.append("'' ");
                }
                ++n;
            }
            stringBuffer.append(NL);
        }
    }

    public static void writeDataSource(ChartDataModel chartDataModel, String string, boolean bl) throws IOException {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0 || string == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            System.out.println("Cannot open filename:" + string);
            iOException.printStackTrace();
        }
        ChartDataSourceUtil.writeDataSource(chartDataModel, fileOutputStream, bl);
    }

    public static void writeDataSource(ChartDataModel chartDataModel, OutputStream outputStream, boolean bl) throws IOException {
        if (chartDataModel == null || chartDataModel.getNumSeries() <= 0 || outputStream == null) {
            return;
        }
        DataOutputStream dataOutputStream = null;
        dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        if (dataOutputStream == null) {
            return;
        }
        String string = ChartDataSourceUtil.buildDataSourceString(chartDataModel, bl);
        if (string != null) {
            dataOutputStream.write(string.getBytes());
        }
    }

    public static String expandText(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length() - 1;
        while (n >= 0) {
            char c = stringBuffer.charAt(n);
            char c2 = c;
            if (c2 < lowCharacterBound || c2 > highCharacterBound) {
                String string2 = Integer.toString(c2);
                StringBuffer stringBuffer2 = new StringBuffer("&#");
                stringBuffer2.append(string2);
                stringBuffer2.append(";");
                stringBuffer.replace(n, n + 1, stringBuffer2.toString());
            }
            --n;
        }
        return stringBuffer.toString();
    }

    public static String processText(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length() - 1) {
            if (stringBuffer.charAt(n) == '&' && stringBuffer.charAt(n + 1) == '#') {
                boolean bl = false;
                int n2 = n + 2;
                StringBuffer stringBuffer2 = new StringBuffer();
                while (stringBuffer.length() > n2) {
                    char c = stringBuffer.charAt(n2);
                    if (c == ';') {
                        if (stringBuffer2.length() <= 0) break;
                        bl = true;
                        break;
                    }
                    if (!Character.isDigit(c)) break;
                    stringBuffer2.append(c);
                    ++n2;
                }
                if (bl) {
                    String string2 = stringBuffer.substring(n + 2, n2);
                    int n3 = Integer.valueOf(string2);
                    stringBuffer.delete(n + 1, n2 + 1);
                    stringBuffer.setCharAt(n, (char)n3);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

