/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class JCIPAddress
implements Serializable {
    protected int[] address = new int[4];
    public static int MAX_VALUE = 255;
    public static int MIN_VALUE = 0;

    public JCIPAddress(String string) {
        this.parseStringIP(string);
    }

    public JCIPAddress(InetAddress inetAddress) {
        this.parseStringIP(inetAddress.getHostAddress());
    }

    public JCIPAddress(int[] nArray) {
        int n = Math.min(4, nArray.length);
        int n2 = 0;
        while (n2 < n) {
            this.address[n2] = nArray[n2];
            ++n2;
        }
    }

    protected void parseStringIP(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return;
        }
        this.address[0] = Integer.valueOf(stringTokenizer.nextToken());
        this.address[1] = Integer.valueOf(stringTokenizer.nextToken());
        this.address[2] = Integer.valueOf(stringTokenizer.nextToken());
        this.address[3] = Integer.valueOf(stringTokenizer.nextToken());
    }

    public String toString() {
        return this.address[0] + "." + this.address[1] + "." + this.address[2] + "." + this.address[3];
    }

    public InetAddress getInetAddress() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(this.toString());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return inetAddress;
    }

    public int[] getIPAddress() {
        return this.address;
    }
}

