/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.JCIntComparator;
import com.klg.jclass.util.JCMappingSort;
import com.klg.jclass.util.swing.DefaultRowComparator;
import com.klg.jclass.util.swing.JCComparableRow;
import com.klg.jclass.util.swing.JCRowComparator;
import com.klg.jclass.util.swing.JCRowSortTableModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class DefaultRowSortTableModel
extends AbstractTableModel
implements JCRowSortTableModel,
TableModelListener {
    public static final int FORWARD = 1;
    public static final int REVERSE = -1;
    protected int order = 1;
    protected TableModel tableModel = null;
    protected int sortColumn = -1;
    protected int[] indices = null;
    protected int[] reverseIndices = null;
    protected JCRowComparator rowComparator = null;
    protected int[][] keyColumnsArray;
    protected RowIntComparator rowIntComparator = null;
    protected boolean autoSort = false;
    protected boolean needsResorting = true;
    protected boolean needsReordering = true;

    public DefaultRowSortTableModel(TableModel tableModel, JCRowComparator jCRowComparator) {
        this(tableModel);
        this.rowComparator = jCRowComparator;
    }

    public DefaultRowSortTableModel(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public TableModel getModel() {
        return this.tableModel;
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == this.tableModel) {
            return;
        }
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this);
        }
        this.tableModel = tableModel;
        tableModel.addTableModelListener(this);
    }

    public void setKeyColumns(int n, int[] nArray) {
        if (this.keyColumnsArray == null) {
            this.keyColumnsArray = new int[this.tableModel.getColumnCount()][];
        }
        this.keyColumnsArray[n] = nArray;
    }

    public int[] getKeyColumns(int n) {
        return this.keyColumnsArray[n];
    }

    public boolean isDataSorted() {
        return this.indices != null && !this.needsReordering && !this.needsResorting;
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public void setAutoSort(boolean bl) {
        if (this.autoSort == bl) {
            return;
        }
        this.autoSort = bl;
        if (bl) {
            this.setDataSorted(true);
        }
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public void setSortColumn(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Sorting column number is less than 0");
        }
        if (this.sortColumn == n) {
            return;
        }
        this.sortColumn = n;
        this.needsResorting = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public int getSortOrder() {
        return this.order;
    }

    public void setSortOrder(int n) {
        if (n == this.order) {
            return;
        }
        this.order = n;
        this.needsReordering = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public void toggleSortOrder() {
        this.order = this.order == 1 ? -1 : 1;
        this.needsReordering = true;
    }

    public int getUnsortedRow(int n) {
        if (n < 0) {
            return n;
        }
        if (this.indices == null) {
            return n;
        }
        if (this.order == 1) {
            return this.indices[n];
        }
        return this.indices[this.indices.length - n - 1];
    }

    public int getSortedRow(int n) {
        if (n < 0) {
            return n;
        }
        if (this.reverseIndices == null) {
            return n;
        }
        if (this.order == 1) {
            return this.reverseIndices[n];
        }
        return this.reverseIndices.length - this.reverseIndices[n] - 1;
    }

    public void setComparator(JCRowComparator jCRowComparator) {
        if (this.rowComparator == jCRowComparator) {
            return;
        }
        this.rowComparator = jCRowComparator;
        this.needsResorting = true;
        if (this.autoSort) {
            this.setDataSorted(true);
        }
    }

    public JCRowComparator getComparator() {
        return this.rowComparator;
    }

    public void setDataSorted(boolean bl) {
        if (!bl) {
            this.unsort();
            return;
        }
        if (this.sortColumn == -1) {
            return;
        }
        if (!this.needsReordering && !this.needsResorting) {
            return;
        }
        if (this.needsResorting) {
            if (this.rowComparator == null) {
                this.rowComparator = new DefaultRowComparator(1);
            }
            if (this.keyColumnsArray == null) {
                this.keyColumnsArray = new int[this.tableModel.getColumnCount()][];
            }
            int[] nArray = new int[]{this.sortColumn};
            this.rowComparator.setKeyColumns(this.keyColumnsArray[this.sortColumn] != null ? this.keyColumnsArray[this.sortColumn] : nArray);
            this.setComparator(this.rowComparator);
            if (this.rowIntComparator == null) {
                this.rowIntComparator = new RowIntComparator();
            }
            if (this.indices == null) {
                this.indices = new int[this.tableModel.getRowCount()];
                this.reverseIndices = new int[this.tableModel.getRowCount()];
                int n = 0;
                while (n < this.indices.length) {
                    this.indices[n] = n;
                    ++n;
                }
            }
            JCMappingSort.sort(this.rowIntComparator, this.indices);
            this.doReverseMapping();
            this.needsResorting = false;
        }
        this.needsReordering = false;
        this.fireTableDataChanged();
    }

    public void unsort() {
        if (this.indices != null) {
            this.indices = null;
            this.reverseIndices = null;
            this.sortColumn = -1;
        }
        this.fireTableDataChanged();
    }

    protected void doReverseMapping() {
        if (this.indices == null || this.reverseIndices == null) {
            return;
        }
        int n = 0;
        while (n < this.tableModel.getRowCount()) {
            this.reverseIndices[this.indices[n]] = this.order == 1 ? n : this.indices.length - n - 1;
            ++n;
        }
    }

    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    public int getRowCount() {
        return this.tableModel.getRowCount();
    }

    public String getColumnName(int n) {
        return this.tableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.tableModel.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.tableModel.isCellEditable(n, n2);
    }

    public Object getValueAt(int n, int n2) {
        return this.tableModel.getValueAt(this.getUnsortedRow(n), n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.tableModel.setValueAt(object, this.getUnsortedRow(n), n2);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.autoSort) {
            this.indices = null;
            this.reverseIndices = null;
            this.needsResorting = true;
            this.setDataSorted(true);
        } else {
            this.unsort();
        }
    }

    class RowIntComparator
    implements JCIntComparator {
        private ComparableRow r1;
        private ComparableRow r2;

        RowIntComparator() {
            this.r1 = new ComparableRow();
            this.r2 = new ComparableRow();
        }

        public int compare(int n, int n2) {
            this.r1.row = n;
            this.r2.row = n2;
            return DefaultRowSortTableModel.this.rowComparator.compare(this.r1, this.r2);
        }
    }

    class ComparableRow
    implements JCComparableRow {
        private int row = -1;

        ComparableRow() {
        }

        public Object getValueAt(int n) {
            return DefaultRowSortTableModel.this.tableModel.getValueAt(this.row, n);
        }

        public int getRowIndex() {
            return this.row;
        }
    }
}

