/*
 * Decompiled with CFR 0.152.
 */
package com.openit.lego.swing;

import com.openit.lego.swing.SwingConstants;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class UIParameters
extends UIManager {
    public UIParameters() {
        this.init();
        UIManager.put("TabbedPane.selected", this.getSecondaryBackground());
        UIManager.put("TextField.inactiveBackground", this.getSecondaryBackground());
        UIManager.put("ComboBox.disabledBackground", this.getSecondaryBackground());
        UIManager.put("Button.background", this.getSecondaryBackground());
        UIManager.put("Panel.background", this.getPrimaryBackground());
        UIManager.put("Label.background", this.getPrimaryBackground());
        UIManager.put("CheckBox.background", this.getPrimaryBackground());
        UIManager.put("TextArea.background", this.getPrimaryBackground());
        UIManager.put("MenuItem.background", this.getPrimaryBackground());
        UIManager.put("ComboBox.background", this.getPrimaryBackground());
        UIManager.put("TextField.background", this.getPrimaryBackground());
        UIManager.put("TextArea.background", this.getPrimaryBackground());
        UIManager.put("Tree.background", this.getPrimaryBackground());
        UIManager.put("TextPane.background", this.getPrimaryBackground());
        UIManager.put("ScrollBar.background", this.getPrimaryBackground());
        UIManager.put("ScrollBar.foreground", this.getPrimaryBackground());
        UIManager.put("OptionPane.background", this.getPrimaryBackground());
        UIManager.put("SplitPane.background", this.getPrimaryBackground());
        UIManager.put("List.border", this.getInnerBorder());
        UIManager.put("ComboBox.border", this.getInnerBorder());
        UIManager.put("TextPane.border", this.getInnerBorder());
        UIManager.put("TextArea.border", this.getInnerBorder());
        UIManager.put("TextField.border", this.getInnerBorder());
    }

    protected void init() {
        UIParameters.put("primaryForeground", SwingConstants.COL_FG_PRIMARY);
        UIParameters.put("secondaryForeground", SwingConstants.COL_FG_SECONDARY);
        UIParameters.put("primaryBackground", SwingConstants.COL_BG_PRIMARY);
        UIParameters.put("secondaryBackground", SwingConstants.COL_BG_SECONDARY);
        UIParameters.put("tertiaryBackground", SwingConstants.COL_BG_TERTIARY);
        UIParameters.put("innerBorderSize", new Integer(3));
        UIParameters.put("outerBorderSize", new Integer(5));
    }

    public Color getPrimaryForeground() {
        return UIParameters.getColor("primaryForeground");
    }

    public Color getSecondaryForeground() {
        return UIParameters.getColor("secondaryForeground");
    }

    public Color getPrimaryBackground() {
        return UIParameters.getColor("primaryBackground");
    }

    public Color getSecondaryBackground() {
        return UIParameters.getColor("secondaryBackground");
    }

    public Color getTertiaryBackground() {
        return UIParameters.getColor("tertiaryBackground");
    }

    public Border getInnerBorder() {
        Integer size = (Integer)UIParameters.get("innerBorderSize");
        return this.getBorder(size);
    }

    public Border getOuterBorder() {
        Integer size = (Integer)UIParameters.get("outerBorderSize");
        return this.getBorder(size);
    }

    protected Border getBorder(int size) {
        return BorderFactory.createLineBorder(this.getSecondaryForeground(), size);
    }
}

