#!/bin/sh

. /tmp/openit-cfg-shenv

# Author : Romnick C. Coros
# Last Update : July 29, 2016

#Add X-XSS-Protection and RequedReadTimeout
sed -i '/<IfModule mod_ssl.c>/i\
<IfModule headers_module> \
	Header set X-XSS-Protection \"1; mode=block\" \
	Header always append X-Frame-Options SAMEORIGIN \
</IfModule> \
 \
TraceEnable Off \
 \
<IfModule reqtimeout_module> \
	RequestReadTimeout header=20-50,MinRate=500 body=20,MinRate=500 \
</IfModule> \
' $CONFIG_DIR/httpd/httpd.conf

#FcgidMaxRequestLen. Fix for Bug #7227
#Remove if it already exists
sed -i '/FcgidMaxRequestLen*/d' $CONFIG_DIR/httpd/httpd.conf
sed -i '/FcgidMaxProcessesPerClass/a\
	FcgidMaxRequestLen 2000000' $CONFIG_DIR/httpd/httpd.conf

