@echo off
SETLOCAL ENABLEEXTENSIONS
SETLOCAL DISABLEDELAYEDEXPANSION
title Updating php.ini

REM Check if it's a 32 or 64bit installation
REG QUERY "HKLM\Hardware\Description\System\CentralProcessor\0" | find /i "x86" > NUL && set OS=32BIT || set OS=64BIT

REM Get the installDir from registry
if %OS%==32BIT FOR /F "tokens=3*" %%a IN ('REG QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\OpeniT\CoreServer\Install" /V "InstallDir" 2^>nul ^|findstr /ri "REG_SZ"') DO (set installDir=%%a %%b)
if %OS%==64BIT FOR /F "tokens=3*" %%a IN ('REG QUERY "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\OpeniT\CoreServer\Install" /V "InstallDir" 2^>nul ^|findstr /ri "REG_SZ"') DO (set "installDir=%%a %%b")

REM Initialize value for phpDir,PhpIni and httpdsslTemp
SET phpDir=%installDir%Configuration\httpd\
SET serverRoot=%installDir%External\Apache\
SET httpd=httpd.conf
SET httpdssl=httpd-ssl.conf
SET httpdsslTemp=httpd-ssl.conf.temp

pushd %phpDir%

REM Get the short name of ServerRoot
for %%I in ("%serverRoot%") do set "serverRoot=%%~sI"
echo %serverRoot%

REM Get the value of ServerName
for /F "delims=" %%a in ('findstr /I "ServerName " %httpd%') do set "ServerName=%%a"
for /f "tokens=2" %%a IN ("%ServerName%") DO set "ServerName=%%a"
echo %ServerName%

REM Get the value of ServerAdmin
for /F "delims=" %%a in ('findstr /I "ServerAdmin " %httpd%') do set "ServerAdmin=%%a"
for /f "tokens=2" %%a IN ("%ServerAdmin%") DO set "ServerAdmin=%%a"
echo %ServerAdmin%

REM Get the value of SSL DIR
for /F "delims=" %%a in ('findstr /I "Listen " %httpdssl%') do set "SSLPORT=%%a"
for /f "tokens=2" %%a IN ("%SSLPORT%") DO set "SSLPORT=%%a"
echo %SSLPORT%

REM Set the string that needs to be replaced
REM SET "search="@@ServerRoot@@"
REM SET "replace="%phpDir%"
REM set search=%search:"=%
REM set replace=%replace:"=%
REM 
REM REM Replace the value of extension dir with value using installDir
REM pushd %phpDir%
REM echo %~dp0
REM (for /f "delims=" %%i in (%httpdssl%) do (
REM     set "line=%%i"
REM     setlocal enabledelayedexpansion
REM     set "line=!line:%search%=%replace%!"
REM     echo(!line!
REM     endlocal
REM ))>"%httpdsslTemp%"
REM del %httpdssl%
REM rename %httpdsslTemp%  %httpdssl%
