#!/bin/sh

. /tmp/openit-cfg-shenv

# Author : Romnick C. Coros
# Modified : Laddy I. Ayala
# Last Update : October 10, 2017


#Declare variables for the current httpd.conf
HTTPD=$CONFIG_DIR/httpd/httpd.conf
OLD_HTTPD=$CONFIG_DIR/httpd/httpd.conf.pre_7-0-6-0

#Get values from the old httpd.conf
user=`grep "User " $OLD_HTTPD | cut -d " " -f2`
group=`grep "Group " $OLD_HTTPD | cut -d " " -f2`
port=`grep "Listen " $OLD_HTTPD | cut -d " " -f2`

#Make sure that we'll be using the port configured before 7.0.6
sed -i -e '0,/^Listen .*$/ s/^Listen .*$/Listen '$port'/' $HTTPD


#Make sure TEMP_DIR/httpd and ROOT_TEMP_DIR is owned by the openit service account
chown -R $user:$group $TEMP_DIR/httpd
chown -R $user:$group $ROOT_TEMP_DIR/log/httpd