// CodeMirror, copyright (c) by Marijn Haverbeke and others
// Distributed under an MIT license: http://codemirror.net/LICENSE

(function(mod) {
  if (typeof exports == "object" && typeof module == "object") // CommonJS
    mod(require("../../lib/codemirror"));
  else if (typeof define == "function" && define.amd) // AMD
    define(["../../lib/codemirror"], mod);
  else // Plain browser env
    mod(CodeMirror);
})(function(CodeMirror) {
"use strict";

CodeMirror.defineMode("handleconfig", function(config) {
  
  var matching = {};
  var curPunc;

  function tokenBase(stream, state) {
    if (stream.eatSpace()) return null;
    var ch = stream.next(), m;
    if (ch == "#") {
      stream.skipToEnd();
      return "comment";
    } else if ( ch == "\\" ) {
	  return "operator"
	} else if (/[a-zA-Z_\xa1-\uffff]/.test(ch)) {
      stream.eatWhile(/[\w\xa1-\uffff]/);
      stream.eat(/[\?\!]/);
      return "ident";
    } else {
      return null;
    }
  }

  return {
    startState: function() {
      return {tokenize: [tokenBase],
              indented: 0,
              context: {type: "top", indented: -config.indentUnit},
              continuedLine: false,
              lastTok: null,
              varList: false};
    },

    token: function(stream, state) {
      var style = state.tokenize[state.tokenize.length-1](stream, state), kwtype;

  	  if( style && style != "comment" && style != "operator" ) {
  	    var word = stream.current();
  	    //style = keywords.propertyIsEnumerable(word) ? "keyword"
  	    //  : attributes.propertyIsEnumerable(word) ? "string" : "variable"
        style = "string";
  	  }
	  
  	  if(stream.match(/https?:\/\/(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/)){
  		  style = "link"
  	  }
      
      return style;
    },

    lineComment: "#"
  };
});

CodeMirror.defineMIME("text/x-handleconfig", "handleconfig");

});
